/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.jei;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.hooks.jei.InfusionRecipeWrapper;
import net.tslat.aoa3.utils.StringUtil;

@SideOnly(value=Side.CLIENT)
public class ImbuingRecipeCategory
implements IRecipeCategory<InfusionRecipeWrapper> {
    private final IDrawable background;
    private final IDrawable icon;
    private final ICraftingGridHelper craftingGridHelper;

    public ImbuingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("aoa3", "textures/gui/containers/infusion_table.png"), 10, 10, 156, 66);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)BlockRegister.infusionTable));
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return "aoa3.imbuing";
    }

    public String getTitle() {
        return StringUtil.getLocaleString("container.aoa3.imbuing");
    }

    public String getModName() {
        return "Advent of Ascension";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfusionRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiStacks = recipeLayout.getItemStacks();
        guiStacks.init(0, false, 127, 24);
        guiStacks.init(1, true, 6, 24);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                guiStacks.init(2 + x + y * 3, true, 34 + x * 18, 6 + y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        ResourceLocation recipeRegistryName = recipeWrapper.getRegistryName();
        guiStacks.set(0, (List)outputs.get(0));
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiStacks, inputs, 3, 3);
        recipeLayout.setShapeless();
        if (recipeRegistryName != null) {
            guiStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    if (!recipeRegistryName.func_110624_b().equals("aoa3")) {
                        tooltip.add(TextFormatting.GRAY + StringUtil.getLocaleStringWithArguments("jei.tooltip.recipe.by", recipeRegistryName.func_110624_b()));
                    }
                    if (Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n()) {
                        tooltip.add(TextFormatting.DARK_GRAY + StringUtil.getLocaleStringWithArguments("jei.tooltip.recipe.id", recipeRegistryName.toString()));
                    }
                }
            });
        }
    }
}

