/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.crafting.recipes.InfusionTableRecipe;
import net.tslat.aoa3.crafting.recipes.UpgradeKitRecipe;
import net.tslat.aoa3.hooks.ThirdPartyInteractions;
import net.tslat.aoa3.hooks.jei.FrameRecipeCategory;
import net.tslat.aoa3.hooks.jei.FrameRecipeWrapper;
import net.tslat.aoa3.hooks.jei.ImbuingRecipeCategory;
import net.tslat.aoa3.hooks.jei.InfusionRecipeCategory;
import net.tslat.aoa3.hooks.jei.InfusionRecipeWrapper;
import net.tslat.aoa3.hooks.jei.UpgradeRecipeCategory;
import net.tslat.aoa3.hooks.jei.UpgradeRecipeWrapper;
import net.tslat.aoa3.hooks.jei.WhitewashingRecipeCategory;
import net.tslat.aoa3.hooks.jei.WhitewashingRecipeWrapper;

@JEIPlugin
public class JeiHooks
implements IModPlugin {
    public void register(IModRegistry registry) {
        AdventOfAscension.logOptionalMessage("Beginning JEI Integration");
        this.registerHiddenItems(registry);
        registry.handleRecipes(InfusionTableRecipe.class, (IRecipeWrapperFactory)new InfusionRecipeWrapper.Factory(), "aoa3.infusion");
        registry.handleRecipes(InfusionTableRecipe.class, (IRecipeWrapperFactory)new InfusionRecipeWrapper.Factory(), "aoa3.imbuing");
        registry.handleRecipes(UpgradeKitRecipe.class, (IRecipeWrapperFactory)new UpgradeRecipeWrapper.Factory(), "aoa3.upgradeKits");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.infusionTable), new String[]{"aoa3.infusion"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.infusionTable), new String[]{"aoa3.imbuing"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.frameBench), new String[]{"aoa3.frameBench"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.whitewashingTable), new String[]{"aoa3.whitewashing"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegister.divineStation), new String[]{"aoa3.upgradeKits"});
        registry.addRecipes(this.compileFrameBenchRecipes(), "aoa3.frameBench");
        registry.addRecipes(this.compileWhitewashingRecipes(), "aoa3.whitewashing");
        registry.addRecipes(this.compileUpgradeKitRecipes(), "aoa3.upgradeKits");
        this.compileInfusionRecipes(registry);
    }

    private void registerHiddenItems(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.alienOrb));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.fleshyBones));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.millenniumUpgrader));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.moltenUpgrader));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.moonstone));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.oldBoot));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ItemRegister.yetiFingernails));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)WeaponRegister.blasterColourCannon));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)WeaponRegister.blasterExperimentW801));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Item)WeaponRegister.gunShoeFlinger));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampAmethyst));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampAquatic));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampBaronyte));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampBlazium));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampBloodstone));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampCrystallite));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampElecanium));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampEmberstone));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampFire));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampGhastly));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampGhoulish));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIro));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIvory));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIvoryAmethyst));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIvoryJade));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIvoryLimonite));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIvoryRosite));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampIvorySapphire));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampJade));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeAqua));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeBlack));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeBlue));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeBrown));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeCyan));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeDarkGrey));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeGreen));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeGrey));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeLime));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeMagenta));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeOrange));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifePink));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifePurple));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeRed));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeWhite));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLifeYellow));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLimonite));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLunar));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampLyon));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampMystic));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeon));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeonCircling));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeonLapis));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeonLapisCircling));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeonLapisTriangles));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeonRunic));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampNeonTriangles));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampRosite));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampSapphire));
        blacklist.addIngredientToBlacklist((Object)new ItemStack((Block)BlockRegister.lampSkeletal));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImbuingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FrameRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new WhitewashingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new UpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    private ArrayList<UpgradeKitRecipe> compileUpgradeKitRecipes() {
        ArrayList<UpgradeKitRecipe> upgradeKitRecipes = new ArrayList<UpgradeKitRecipe>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            if (!(recipe instanceof UpgradeKitRecipe)) continue;
            upgradeKitRecipes.add((UpgradeKitRecipe)recipe);
        }
        return upgradeKitRecipes;
    }

    private void compileInfusionRecipes(IModRegistry registry) {
        ArrayList<InfusionTableRecipe> infusionRecipes = new ArrayList<InfusionTableRecipe>();
        ArrayList<InfusionTableRecipe> imbuingRecipes = new ArrayList<InfusionTableRecipe>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            if (!(recipe instanceof InfusionTableRecipe)) continue;
            if (((InfusionTableRecipe)recipe).isEnchanting()) {
                imbuingRecipes.add((InfusionTableRecipe)recipe);
                continue;
            }
            infusionRecipes.add((InfusionTableRecipe)recipe);
        }
        registry.addRecipes(infusionRecipes, "aoa3.infusion");
        registry.addRecipes(imbuingRecipes, "aoa3.imbuing");
    }

    private ArrayList<FrameRecipeWrapper> compileFrameBenchRecipes() {
        ArrayList<FrameRecipeWrapper> frameRecipes = new ArrayList<FrameRecipeWrapper>(10);
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameArchergun));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameBlaster));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameCannon));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameHelmet));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameChestplate));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameLeggings));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameBoots));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameGun));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameShotgun));
        frameRecipes.add(new FrameRecipeWrapper(ItemRegister.frameSniper));
        return frameRecipes;
    }

    private ArrayList<WhitewashingRecipeWrapper> compileWhitewashingRecipes() {
        ArrayList<WhitewashingRecipeWrapper> whitewashingRecipes = new ArrayList<WhitewashingRecipeWrapper>(2);
        whitewashingRecipes.add(new WhitewashingRecipeWrapper(BlockRegister.bricksWhitewash));
        whitewashingRecipes.add(new WhitewashingRecipeWrapper(BlockRegister.bricksDarkwash));
        return whitewashingRecipes;
    }

    static {
        ThirdPartyInteractions.setJEIActive();
    }
}

