/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class BattlebornArmour
extends AdventArmour {
    public BattlebornArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_BATTLEBORN, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.BATTLEBORN;
    }

    @Override
    public void onDamageDealt(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && EntityUtil.isMeleeDamage(event.getSource())) {
            int counter = plData.equipment().getCooldown(Enums.Counters.BATTLEBORN);
            int newAmount = Math.min(300, counter + slots.size() * 6);
            plData.equipment().setCooldown(Enums.Counters.BATTLEBORN, newAmount);
            EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.BATTLEBORN_ARMOUR_BUFF);
            EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.battlebornArmourBuff(Math.min(0.65, (double)newAmount / 240.0)));
        }
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        int counter = plData.equipment().getCooldown(Enums.Counters.BATTLEBORN);
        if (counter == 1) {
            EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.BATTLEBORN_ARMOUR_BUFF);
        } else if (counter > 0 && plData.player().field_70170_p.func_82737_E() % 10L == 0L) {
            EntityUtil.removeAttributeModifier((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.battlebornArmourBuff(counter));
            EntityUtil.applyAttributeModifierSafely((EntityLivingBase)plData.player(), SharedMonsterAttributes.field_188790_f, AoAAttributes.battlebornArmourBuff(Math.min(0.65, (double)counter / 240.0)));
        }
    }

    @Override
    public void onUnequip(PlayerDataManager plData, @Nullable EntityEquipmentSlot slot) {
        int cooldown;
        if (slot != null && (cooldown = plData.equipment().getCooldown(Enums.Counters.BATTLEBORN)) > 0) {
            plData.equipment().setCooldown(Enums.Counters.BATTLEBORN, (int)((float)cooldown * 0.75f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.BattlebornArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.BattlebornArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
    }
}

