/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class ElecanyteArmour
extends AdventArmour {
    public ElecanyteArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_ELECANYTE, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.ELECANYTE;
    }

    @Override
    public void onPostAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingDamageEvent event) {
        if (slots != null && !EntityUtil.isEnvironmentalDamage(event.getSource())) {
            plData.stats().regenResource(Enums.Resources.ENERGY, event.getAmount() * 2.5f * (float)slots.size());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ElecanyteArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ElecanyteArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
    }
}

