/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class ExoplateArmour
extends AdventArmour {
    public ExoplateArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_EXOPLATE, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.EXOPLATE;
    }

    @Override
    public void onAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && !EntityUtil.isEnvironmentalDamage(event.getSource())) {
            EntityLivingBase entity = event.getEntityLiving();
            BlockPos playerPos = entity.func_180425_c();
            Chunk chunk = entity.field_70170_p.func_175726_f(playerPos);
            int lightLvl = MathHelper.func_76125_a((int)(2 + Math.max(chunk.func_177413_a(EnumSkyBlock.SKY, playerPos) - entity.field_70170_p.func_175657_ab(), entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, playerPos))), (int)0, (int)15);
            event.setAmount(event.getAmount() * (1.0f - (1.0f - (float)lightLvl / 15.0f) * 0.0625f * (float)slots.size()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ExoplateArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
    }
}

