/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class ExtractionArmour
extends AdventArmour
implements SkillItem {
    public ExtractionArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_EXTRACTION, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.EXTRACTION;
    }

    @Override
    public Enums.Skills getSkill() {
        return Enums.Skills.EXTRACTION;
    }

    @Override
    public int getLevelReq() {
        return 100;
    }

    @Override
    public void addBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EntityEquipmentSlot slot) {
        if (slot == null) {
            plBuffs.addXpModifier(Enums.Skills.EXTRACTION, 0.3f);
        }
    }

    @Override
    public void removeBuffs(PlayerDataManager.PlayerBuffs plBuffs, @Nullable EntityEquipmentSlot slot) {
        if (slot == null) {
            plBuffs.removeXpModifier(Enums.Skills.EXTRACTION, 0.3f);
        }
    }

    @Override
    public void onPreAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingAttackEvent event) {
        if (slots == null && event.getSource().func_76347_k()) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onEffectTick(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots) {
        if (slots == null && plData.player().func_180799_ab()) {
            plData.player().field_70159_w *= 1.8;
            plData.player().field_70179_y *= 1.8;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ExtractionArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.skillXpBonus", Enums.ItemDescriptionType.POSITIVE, Integer.toString(30), StringUtil.getLocaleString("skills.extraction.name")));
        tooltip.add(ItemUtil.getFormattedLevelRestrictedDescriptionText(Enums.Skills.EXTRACTION, 100));
    }
}

