/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;

public class MercurialArmour
extends AdventArmour {
    public MercurialArmour(String name, String registryName, EntityEquipmentSlot slot) {
        super(MaterialsRegister.ARMOUR_MERCURIAL, name, registryName, slot);
    }

    @Override
    public Enums.ArmourSets setType() {
        return Enums.ArmourSets.MERCURIAL;
    }

    @Override
    public void onPreAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingAttackEvent event) {
        if (slots == null && !event.getEntity().field_70170_p.field_72995_K && event.getSource().func_94541_c() && event.getAmount() > 0.0f) {
            float remainingDamage = event.getAmount() * 0.4f;
            plData.player().field_71071_by.func_70449_g(10.0f + remainingDamage * 2.0f * field_77697_d.nextFloat());
            event.setCanceled(true);
        }
    }

    @Override
    public void onAttackReceived(PlayerDataManager plData, @Nullable HashSet<EntityEquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && event.getSource().func_94541_c() && event.getAmount() > 0.0f) {
            event.setAmount(event.getAmount() * (1.0f - 0.15f * (float)slots.size()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.pieceEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.MercurialArmour.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(this.setEffectHeader());
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.MercurialArmour.desc.2", Enums.ItemDescriptionType.POSITIVE));
    }
}

