/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.minionslab;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class BaseSlab
extends Item {
    public final int lvl;
    public final float cost;
    public final int sacrificeLvl;
    public final float sacrificeXp;

    public BaseSlab(String name, String registryName, int lvl, float creationCost, int sacrificeLvl, float sacrificeXp) {
        this.func_77655_b(name);
        this.setRegistryName("aoa3:" + registryName);
        this.lvl = lvl;
        this.cost = creationCost;
        this.sacrificeLvl = sacrificeLvl;
        this.sacrificeXp = sacrificeXp;
        this.func_77637_a(CreativeTabsRegister.minionSlabsTab);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            if (!player.field_71075_bZ.field_75098_d && !PlayerUtil.doesPlayerHaveLevel(player, Enums.Skills.CREATION, this.lvl)) {
                if (player instanceof EntityPlayerMP) {
                    PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.CREATION, this.lvl);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            if (player.field_71075_bZ.field_75098_d || plData.stats().consumeResource(Enums.Resources.CREATION, this.cost, false)) {
                AoAMinion minion;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if ((minion = this.activateSlab(player, stack)) != null && plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.CREATION) {
                    this.applyBuffs(minion);
                }
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundsRegister.useCreationSlab, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public abstract AoAMinion activateSlab(EntityPlayer var1, ItemStack var2);

    protected void applyBuffs(AoAMinion minion) {
        switch (field_77697_d.nextInt(4)) {
            case 0: {
                minion.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 1, true, true));
                break;
            }
            case 1: {
                minion.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 1, true, true));
                break;
            }
            case 2: {
                minion.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 1200, 1, true, true));
                break;
            }
            case 3: {
                minion.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1200, 1, true, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.slab.cost", TextFormatting.LIGHT_PURPLE, Integer.toString((int)this.cost)));
        if (AdventGuiTabPlayer.getSkillLevel(Enums.Skills.CREATION) < this.lvl) {
            tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.skillRequirement", TextFormatting.RED, Integer.toString(this.lvl), StringUtil.getLocaleString("skills.creation.name")));
        } else {
            tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.skillRequirement", TextFormatting.GREEN, Integer.toString(this.lvl), StringUtil.getLocaleString("skills.creation.name")));
        }
    }
}

