/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.boss.bane.EntityBane;
import net.tslat.aoa3.item.misc.summon.BossSpawningItem;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class HauntedIdol
extends BossSpawningItem {
    public HauntedIdol() {
        super("HauntedIdol", "haunted_idol", SoundsRegister.mobBaneLiving, EnumParticleTypes.PORTAL, EnumParticleTypes.SPELL_MOB);
    }

    @Override
    public void spawnBoss(World world, EntityPlayer summoner, double posX, double posY, double posZ) {
        EntityBane bane = new EntityBane(world);
        bane.func_70012_b(posX, posY, posZ, field_77697_d.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)bane);
        StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.bane.spawn", summoner.getDisplayNameString()), (Entity)bane, 50);
    }

    @Override
    public boolean canSpawnHere(World world, EntityPlayer player, double posX, double posY, double posZ) {
        if (world.field_73011_w.getDimension() != ConfigurationUtil.MainConfig.dimensionIds.greckon) {
            PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.mob.bane.incorrectDimension", new Object[0]);
            return false;
        }
        if (world.func_184143_b(new AxisAlignedBB(posX - 0.5, posY, posZ - 0.5, posX + 0.5, posY + 2.5, posZ + 0.5))) {
            PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.feedback.spawnBoss.noSpace", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(StringUtil.getColourLocaleString("item.HauntedIdol.desc.1", TextFormatting.DARK_PURPLE));
        tooltip.add(StringUtil.getColourLocaleString("items.description.bossSummonItem.unstable", TextFormatting.DARK_RED));
    }
}

