/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.misc.summon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.boss.kingshroomus.EntityKingShroomus;
import net.tslat.aoa3.item.misc.summon.BossSpawningItem;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ShroomStone
extends BossSpawningItem {
    public ShroomStone() {
        super("ShroomStone", "shroom_stone", SoundsRegister.mobKingShroomusHeal, EnumParticleTypes.CLOUD, EnumParticleTypes.SPELL_MOB);
    }

    @Override
    public void spawnBoss(World world, EntityPlayer summoner, double posX, double posY, double posZ) {
        EntityKingShroomus kingShroomus = new EntityKingShroomus(world);
        kingShroomus.func_70012_b(posX, posY, posZ, field_77697_d.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)kingShroomus);
        StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.kingShroomus.spawn", summoner.getDisplayNameString()), (Entity)kingShroomus, 50);
    }

    @Override
    public boolean canSpawnHere(World world, EntityPlayer player, double posX, double posY, double posZ) {
        if (world.field_73011_w.getDimension() != ConfigurationUtil.MainConfig.dimensionIds.mysterium) {
            PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.mob.kingShroomus.incorrectDimension", new Object[0]);
            return false;
        }
        if (world.func_184143_b(new AxisAlignedBB(posX - 0.75, posY, posZ - 0.75, posX + 0.75, posY + 4.0, posZ + 0.75))) {
            PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.feedback.spawnBoss.noSpace", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(StringUtil.getColourLocaleString("item.ShroomStone.desc.1", TextFormatting.LIGHT_PURPLE));
        tooltip.add(StringUtil.getColourLocaleString("items.description.bossSummonItem.unstable", TextFormatting.DARK_RED));
    }
}

