/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStackSerializable;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackSerializeableProvider;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ExpFlask
extends Item {
    public ExpFlask() {
        this.func_77655_b("ExpFlask");
        this.setRegistryName("aoa3:exp_flask");
        this.func_77637_a(CreativeTabsRegister.toolsTab);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("filled"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                CapabilityBaseMiscStackSerializable cap = ExpFlask.getCapability(stack);
                return cap == null || cap.getValue() <= 0.0f ? 0.0f : 1.0f;
            }
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            CapabilityBaseMiscStackSerializable cap = ExpFlask.getCapability(stack);
            if (cap == null || cap.getValue() <= 0.0f) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            player.func_184598_c(hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            CapabilityBaseMiscStackSerializable cap = ExpFlask.getCapability(stack);
            if (cap.getValue() > 0.0f) {
                int xpChange = (int)Math.min((float)(1 + (int)((float)player.field_71068_ca / 15.0f)), cap.getValue());
                player.func_71023_q(xpChange);
                cap.setValue(cap.getValue() - (float)xpChange);
                if (cap.getValue() == 0.0f) {
                    player.func_184602_cy();
                }
            }
        }
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = super.getNBTShareTag(stack);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74776_a("AdventMiscStackCapability", ExpFlask.getCapability(stack).getValue());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("AdventMiscStackCapability")) {
            ExpFlask.getCapability(stack).setValue(nbt.func_74760_g("AdventMiscStackCapability"));
        }
        super.readNBTShareTag(stack, nbt);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventMiscStackSerializeableProvider();
    }

    public static CapabilityBaseMiscStackSerializable getCapability(ItemStack stack) {
        return (CapabilityBaseMiscStackSerializable)stack.getCapability(AdventMiscStackSerializeableProvider.MISC_STACK, null);
    }

    public static void addExp(EntityPlayerMP player, int slot, ItemStack stack, int xp) {
        CapabilityBaseMiscStackSerializable cap = ExpFlask.getCapability(stack);
        if (cap != null) {
            cap.setValue(cap.getValue() + (float)xp);
        }
    }

    public static void setExp(ItemStack stack, int xp) {
        CapabilityBaseMiscStackSerializable cap = ExpFlask.getCapability(stack);
        if (cap != null) {
            cap.setValue(xp);
        }
    }

    public static boolean consumeExp(ItemStack stack, int xp) {
        CapabilityBaseMiscStackSerializable cap = ExpFlask.getCapability(stack);
        if (cap != null && cap.getValue() >= (float)xp) {
            cap.setValue(cap.getValue() - (float)xp);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int storedValue = (int)ExpFlask.getCapability(stack).getValue();
        if (storedValue > 0) {
            tooltip.add(StringUtil.getColourLocaleStringWithArguments("item.ExpFlask.desc.1", TextFormatting.GOLD, StringUtil.floorAndAppendSuffix(storedValue, true) + (storedValue >= 7 ? " (" + PlayerUtil.getPlayerLevelFromExp(storedValue) + ")" : "")));
        }
        tooltip.add(StringUtil.getLocaleString("item.ExpFlask.desc.2"));
        tooltip.add(StringUtil.getLocaleString("item.ExpFlask.desc.3"));
    }
}

