/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.tool.pickaxe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.MaterialsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class GoofyPickaxe
extends BasePickaxe {
    public GoofyPickaxe() {
        super("GoofyPickaxe", "goofy_pickaxe", MaterialsRegister.TOOL_GOOFY);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayerMP) {
            PlayerUtil.playSoundForPlayer((EntityPlayerMP)attacker, SoundsRegister.goofyToolFail, SoundCategory.PLAYERS, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, 1.0f, 1.0f);
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77951_h()) {
            int modulo = isSelected ? 120 : (slot < 9 ? 200 : 280);
            if (world.func_82737_E() % (long)modulo == 0L) {
                stack.func_77964_b(stack.func_77952_i() - 1);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).field_71069_bz.func_75142_b();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.GoofyPickaxe.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.GoofyPickaxe.desc.2", Enums.ItemDescriptionType.NEGATIVE));
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", -1.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        }
        return multimap;
    }
}

