/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.archergun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityHollyArrowShot;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseArchergun
extends BaseGun {
    private double dmg;
    protected int firingDelay;

    public BaseArchergun(double dmg, int durability, int fireDelayTicks, float recoil) {
        super(dmg, durability, fireDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.func_77637_a(CreativeTabsRegister.archergunsTab);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunArchergun;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        return this.findAndConsumeAmmo(player, gun, hand, true);
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand, boolean consume) {
        Item ammo = ItemUtil.findAndConsumeSpecialBullet((EntityLivingBase)player, gun, consume, (Item)ItemRegister.hollyArrow, player.func_184586_b(hand));
        if (ammo != null) {
            EntityHollyArrowShot arrow = new EntityHollyArrowShot((EntityLivingBase)player, gun, hand, 120, 0);
            arrow.field_70181_x += 0.25;
            return arrow;
        }
        return null;
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet arrow, float bulletDmgMultiplier) {
        if (target != null && EntityUtil.dealRangedDamage(target, shooter, (Entity)arrow, (float)this.dmg)) {
            this.doImpactEffect(target, shooter, arrow, bulletDmgMultiplier);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.arrows", TextFormatting.DARK_RED, Double.toString(this.dmg)));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(StringUtil.getColourLocaleString("items.description.ammo.arrows", TextFormatting.LIGHT_PURPLE));
    }
}

