/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class BaseBlaster
extends Item
implements EnergyProjectileWeapon,
AdventWeapon {
    protected final double baseDmg;
    protected final int firingDelay;
    protected final float energyCost;

    public BaseBlaster(double dmg, int durability, int fireDelayTicks, float energyCost) {
        this.baseDmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.energyCost = energyCost;
        this.func_77656_e(durability);
        this.func_77637_a(CreativeTabsRegister.blastersTab);
        this.func_77625_d(1);
        this.func_77664_n();
        this.setNoRepair();
    }

    public double getDamage() {
        return this.baseDmg;
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    public float getEnergyCost() {
        return this.energyCost;
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != this.getWeaponHand()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            int recharge = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.recharge, (ItemStack)stack);
            int greed = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.greed, (ItemStack)stack);
            float energyConsumption = (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (plData.stats().getResourceValue(Enums.Resources.ENERGY) < energyConsumption) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            player.func_184598_c(hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (!player.field_70170_p.field_72995_K) {
            float energyConsumption;
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)player);
            int recharge = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.recharge, (ItemStack)stack);
            int greed = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.greed, (ItemStack)stack);
            float f = energyConsumption = ((EntityPlayer)player).field_71075_bZ.field_75098_d ? 0.0f : (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (plData.stats().getResourceValue(Enums.Resources.ENERGY) >= energyConsumption) {
                if (count + this.firingDelay <= 72000 && count % this.firingDelay == 0) {
                    if (this.consumeEnergy(plData, stack, energyConsumption)) {
                        if (this.getFiringSound() != null) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        this.fire(stack, player);
                        ((EntityPlayer)player).func_71029_a(StatList.func_188057_b((Item)this));
                        if ((72000 - count) / this.firingDelay >= this.getMaxDamage(stack) - stack.func_77952_i()) {
                            stack.func_77972_a((72000 - count) / this.firingDelay, player);
                        }
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else {
                if (player instanceof EntityPlayerMP) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((EntityPlayerMP)player, Enums.Resources.ENERGY, energyConsumption);
                }
                player.func_184597_cx();
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int useTicksRemaining) {
        stack.func_77972_a((72000 - useTicksRemaining - 1) / this.firingDelay, player);
    }

    public abstract void fire(ItemStack var1, EntityLivingBase var2);

    public boolean consumeEnergy(PlayerDataManager plData, ItemStack stack, float cost) {
        return plData.stats().consumeResource(Enums.Resources.ENERGY, cost, false);
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public EnumHand getWeaponHand() {
        return EnumHand.MAIN_HAND;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (EntityUtil.dealBlasterDamage(shooter, target, (Entity)shot, (float)this.baseDmg, false)) {
            this.doImpactEffect(shot, target, shooter);
            return true;
        }
        return false;
    }

    protected void doImpactEffect(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.baseDmg > 0.0) {
            tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.blaster", TextFormatting.DARK_RED, StringUtil.roundToNthDecimalPlace((float)this.baseDmg, 1)));
        }
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.blaster.fire", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.blaster.slowing", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.blaster.effect", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.resource", Enums.ItemDescriptionType.ITEM_AMMO_COST, StringUtil.roundToNthDecimalPlace(this.energyCost, 1), StringUtil.getLocaleString("resources.energy.name")));
    }

    public int func_77619_b() {
        return 8;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("HideFlags", (byte)2);
        return super.initCapabilities(stack, nbt);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)AoAAttributes.vanillaWeaponSpeedModifier(this.firingDelay < 20 ? Enums.WeaponSpeed.THIRD.value : Enums.WeaponSpeed.QUARTER.value));
        }
        return multimap;
    }
}

