/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.item.misc.HollyArrow;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class DaybreakerBow
extends BaseBow {
    public DaybreakerBow(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.func_77655_b("DaybreakerBow");
        this.setRegistryName("aoa3:daybreaker_bow");
    }

    @Override
    protected EntityHollyArrow makeArrow(EntityLivingBase shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        EntityHollyArrow centralArrow = super.makeArrow(shooter, bowStack, ammoStack, velocity, consumeAmmo);
        if (shooter.field_70125_A < -70.0f) {
            for (double x = -0.5; x <= 0.5; x += 0.5) {
                for (double z = -0.5; z <= 0.5; z += 0.5) {
                    if (x == 0.0 && z == 0.0) continue;
                    EntityHollyArrow arrow = this.copyArrow(shooter, bowStack, centralArrow, velocity, ammoStack);
                    arrow.func_70634_a(arrow.field_70165_t + x, arrow.field_70163_u, arrow.field_70161_v + z);
                    arrow.field_70170_p.func_72838_d((Entity)arrow);
                }
            }
        }
        return centralArrow;
    }

    private EntityHollyArrow copyArrow(EntityLivingBase shooter, ItemStack bowStack, EntityHollyArrow arrow, float velocity, ItemStack ammoStack) {
        EntityHollyArrow newArrow = ((HollyArrow)((Object)(ammoStack.func_77973_b() instanceof HollyArrow ? ammoStack.func_77973_b() : ItemRegister.hollyArrow))).createArrow(arrow.field_70170_p, this, ammoStack, shooter, this.dmg);
        newArrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, velocity * 3.0f, 2.0f);
        newArrow.func_70243_d(arrow.func_70241_g());
        newArrow.func_70239_b(arrow.func_70242_d());
        newArrow.func_70240_a(arrow.getKnockbackStrength());
        newArrow.func_70015_d(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bowStack) * 100);
        newArrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
        return newArrow;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.DaybreakerBow.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

