/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class ExplosiveBow
extends BaseBow {
    public ExplosiveBow(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.func_77655_b("ExplosiveBow");
        this.setRegistryName("aoa3:explosive_bow");
    }

    @Override
    public void doImpactEffect(EntityHollyArrow arrow, Entity target, Entity shooter, float damage) {
        if (arrow.func_70241_g()) {
            WorldUtil.createExplosion(shooter, arrow.field_70170_p, (Entity)arrow, 2.0f);
        }
    }

    @Override
    public void doBlockImpact(EntityHollyArrow arrow, IBlockState blockState, Entity shooter) {
        if (arrow.func_70241_g()) {
            WorldUtil.createExplosion(shooter, arrow.field_70170_p, (Entity)arrow, 2.5f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ExplosiveBow.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

