/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.entity.projectiles.arrow.EntityPopShot;
import net.tslat.aoa3.item.misc.HollyArrow;
import net.tslat.aoa3.item.misc.PopShot;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class Slingshot
extends BaseBow {
    private float drawSpeedMultiplier;
    private double dmg;

    public Slingshot(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.drawSpeedMultiplier = drawSpeedMultiplier;
        this.dmg = damage;
        this.func_77655_b("Slingshot");
        this.setRegistryName("aoa3:slingshot");
    }

    @Override
    protected EntityHollyArrow makeArrow(EntityLivingBase shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        EntityPopShot arrowEntity = new EntityPopShot(shooter.field_70170_p, this, shooter, this.dmg, ammoStack.func_77973_b() instanceof HollyArrow);
        arrowEntity.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
        int powerEnchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bowStack);
        int punchEnchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bowStack);
        if (velocity >= 1.0f) {
            arrowEntity.func_70243_d(true);
        }
        if (powerEnchant > 0) {
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)powerEnchant * 1.5 + 1.0);
        }
        if (punchEnchant > 0) {
            arrowEntity.func_70240_a(punchEnchant);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bowStack) > 0) {
            arrowEntity.func_70015_d(100);
        }
        if (!consumeAmmo || shooter instanceof EntityPlayer && ((EntityPlayer)shooter).field_71075_bZ.field_75098_d && (ammoStack.func_77973_b() == Items.field_185166_h || ammoStack.func_77973_b() == Items.field_185167_i)) {
            arrowEntity.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        bowStack.func_77972_a(1, shooter);
        if (shooter instanceof EntityPlayer && consumeAmmo) {
            ammoStack.func_190918_g(1);
            if (ammoStack.func_190926_b()) {
                ((EntityPlayer)shooter).field_71071_by.func_184437_d(ammoStack);
            }
        }
        return arrowEntity;
    }

    @Override
    public void doImpactEffect(EntityHollyArrow shot, Entity target, Entity shooter, float damage) {
        if (shot instanceof EntityPopShot && ((EntityPopShot)shot).isExplosive) {
            WorldUtil.createExplosion(shooter, shot.field_70170_p, (Entity)shot, 1.0f);
        }
        shot.func_70106_y();
    }

    @Override
    public void doBlockImpact(EntityHollyArrow shot, IBlockState blockState, Entity shooter) {
        if (shot instanceof EntityPopShot && ((EntityPopShot)shot).isExplosive) {
            WorldUtil.createExplosion(shooter, shot.field_70170_p, (Entity)shot, 1.0f);
        }
        shot.func_70106_y();
    }

    @Override
    protected boolean func_185058_h_(ItemStack stack) {
        return stack.func_77973_b() instanceof PopShot || stack.func_77973_b() == Items.field_151145_ak;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.arrows", TextFormatting.DARK_RED, Double.toString(this.dmg)));
        tooltip.add(StringUtil.getColourLocaleString("item.Slingshot.desc.1", TextFormatting.DARK_GREEN));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.bow.drawSpeed", Double.toString((double)(72000.0f / this.drawSpeedMultiplier / 720.0f) / 100.0)));
        tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.ammo.other", TextFormatting.LIGHT_PURPLE, StringUtil.getLocaleString("item.PopShot.name") + "/" + StringUtil.getLocaleString("item.flint.name")));
    }
}

