/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.cannon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.cannon.EntityBalloonBomb;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public class BalloonBomber
extends BaseCannon {
    double dmg;
    int firingDelay;

    public BalloonBomber(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
        this.func_77655_b("BalloonBomber");
        this.setRegistryName("aoa3:balloon_bomber");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunBallCannon;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        Item ammo = ItemUtil.findAndConsumeSpecialBullet((EntityLivingBase)player, gun, true, ItemRegister.balloon, player.func_184586_b(hand));
        if (ammo != null) {
            return new EntityBalloonBomb((EntityLivingBase)player, gun, hand, 120, 0);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.gun", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.dmg)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.BalloonBomber.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.cannon.damage", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.other", Enums.ItemDescriptionType.ITEM_AMMO_COST, StringUtil.getLocaleString("item.Balloon.name")));
    }
}

