/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.cannon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.cannon.EntityEnergyShot;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class EnergyCannon
extends BaseCannon {
    double dmg;
    int firingDelay;

    public EnergyCannon(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
        this.func_77655_b("EnergyCannon");
        this.setRegistryName("aoa3:energy_cannon");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunEnergyCannon;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        Item ammo = ItemUtil.findAndConsumeSpecialBullet((EntityLivingBase)player, gun, true, ItemRegister.cannonball, player.func_184586_b(hand));
        if (ammo != null) {
            return new EntityEnergyShot((EntityLivingBase)player, gun, hand, 120, 0);
        }
        return null;
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            if (target instanceof EntityLivingBase) {
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * 1.5 / 100.0));
            }
            EntityUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier * 0.75f);
            EntityUtil.dealMagicDamage((Entity)bullet, shooter, target, (float)this.getDamage() * bulletDmgMultiplier * 0.25f, false);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.EnergyCannon.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

