/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public class LunarAssaultRifle
extends BaseGun {
    private final double baseDmg;
    private final double maxDmg;
    private final int firingDelay;

    public LunarAssaultRifle(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.func_77655_b("LunarAssaultRifle");
        this.setRegistryName("aoa3:lunar_assault_rifle");
        this.firingDelay = firingDelayTicks;
        this.baseDmg = dmg - dmg / 2.0;
        this.maxDmg = dmg + dmg / 2.0;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunSpaceGun;
    }

    @Override
    public double getDamage() {
        return (double)field_77697_d.nextFloat() * (this.maxDmg - this.baseDmg) + this.baseDmg;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.damage.random", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.baseDmg), Double.toString(this.maxDmg)));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.bullets", Enums.ItemDescriptionType.ITEM_AMMO_COST));
    }
}

