/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.shotgun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.capabilities.handlers.AdventGunCapability;
import net.tslat.aoa3.capabilities.providers.AdventGunProvider;
import net.tslat.aoa3.common.packet.PacketRecoil;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityLimoniteBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityMetalSlug;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseShotgun
extends BaseGun
implements AdventWeapon {
    protected final int pelletCount;
    protected final float knockbackFactor;

    public BaseShotgun(double dmg, int pellets, int durability, int fireDelayTicks, float knockbackFactor, float recoil) {
        super(dmg, durability, fireDelayTicks, recoil);
        this.pelletCount = pellets;
        this.knockbackFactor = knockbackFactor;
        this.func_77637_a(CreativeTabsRegister.shotgunsTab);
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.gunShotgun;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != this.getGunHand(stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        AdventGunCapability cap = (AdventGunCapability)stack.getCapability(AdventGunProvider.ADVENT_GUN, null);
        if (cap == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (cap.getNextFireTime() <= GlobalEvents.tick) {
            BaseBullet ammo = this.findAndConsumeAmmo(player, this, hand);
            if (ammo != null) {
                if (!world.field_72995_K) {
                    float form = 0.15f * (float)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.form, (ItemStack)stack);
                    this.fireShotgun((EntityLivingBase)player, hand, 0.1f * (float)this.pelletCount * (1.0f - form), this.pelletCount);
                }
                if (this.getFiringSound() != null) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                cap.setNextShotDelay(this.getFiringDelay());
                if (player instanceof EntityPlayerMP) {
                    int control = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.control, (ItemStack)stack);
                    float recoiling = this.getRecoilForShot(stack, (EntityLivingBase)player) * (1.0f - (float)control * 0.15f);
                    PacketUtil.network.sendTo((IMessage)new PacketRecoil(hand == EnumHand.OFF_HAND ? recoiling * 2.5f : recoiling, this.getFiringDelay()), (EntityPlayerMP)player);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
        } else if (cap.getNextFireTime() > GlobalEvents.tick + this.getFiringDelay() * 2) {
            cap.setNextShotDelay(0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public void fireShotgun(EntityLivingBase shooter, EnumHand hand, float spreadFactor, int pellets) {
        for (int i = 0; i < pellets; ++i) {
            EntityLimoniteBullet pellet = new EntityLimoniteBullet(shooter, this, hand, 4, 1.0f, 0, (field_77697_d.nextFloat() - 0.5f) * spreadFactor, (field_77697_d.nextFloat() - 0.5f) * spreadFactor, (field_77697_d.nextFloat() - 0.5f) * spreadFactor);
            shooter.field_70170_p.func_72838_d((Entity)pellet);
        }
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            float shellMod = 1.0f;
            if (bullet.getHand() != null) {
                shellMod = (float)((double)shellMod + 0.1 * (double)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.shell, (ItemStack)shooter.func_184586_b(bullet.getHand())));
            }
            if (EntityUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier * shellMod)) {
                if (this.knockbackFactor > 0.0f) {
                    EntityUtil.doScaledKnockback((EntityLivingBase)target, (Entity)shooter, this.knockbackFactor, shooter.field_70165_t - target.field_70165_t, shooter.field_70161_v - target.field_70161_v);
                }
                this.doImpactEffect(target, shooter, bullet, bulletDmgMultiplier);
            }
        }
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, BaseGun gun, EnumHand hand) {
        Item ammo = ItemUtil.findAndConsumeSpecialBullet((EntityLivingBase)player, gun, true, ItemRegister.spreadshot, player.func_184586_b(hand));
        if (ammo != null) {
            return new EntityMetalSlug((EntityLivingBase)player, gun, hand, 4, 0);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.shotgun", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.getDamage()), Integer.toString(this.pelletCount)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.damage.knockback", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.spreadshot", Enums.ItemDescriptionType.ITEM_AMMO_COST));
    }
}

