/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.tslat.aoa3.capabilities.handlers.AdventGunCapability;
import net.tslat.aoa3.capabilities.providers.AdventGunProvider;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseStaff
extends Item
implements AdventWeapon,
EnergyProjectileWeapon {
    protected final HashMap<RuneItem, Integer> runes = new HashMap(2);

    public BaseStaff(int durability) {
        this.func_77656_e(durability);
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(CreativeTabsRegister.stavesTab);
        this.setNoRepair();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        Item mainItem;
        ItemStack stack = player.func_184586_b(hand);
        AdventGunCapability cap = (AdventGunCapability)stack.getCapability(AdventGunProvider.ADVENT_GUN, null);
        if (cap == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (hand == EnumHand.OFF_HAND && ((mainItem = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()) instanceof BaseGun || mainItem instanceof BaseBlaster)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (cap.getNextFireTime() < GlobalEvents.tick) {
            if (!world.field_72995_K) {
                Object preconditionResult = this.checkPreconditions((EntityLivingBase)player, stack);
                if (preconditionResult == null) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                }
                if (!this.findAndConsumeRunes(this.getRunes(), player, true, stack)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                }
                if (this.getCastingSound() != null) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getCastingSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                cap.setNextShotDelay(12);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                stack.func_77972_a(1, (EntityLivingBase)player);
                this.cast(world, stack, (EntityLivingBase)player, preconditionResult);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (cap.getNextFireTime() > GlobalEvents.tick + 20) {
            cap.setNextShotDelay(0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean findAndConsumeRunes(HashMap<RuneItem, Integer> runes, EntityPlayer player, boolean allowBuffs, ItemStack staff) {
        return ItemUtil.findAndConsumeRunes(runes, player, allowBuffs, staff);
    }

    @Nullable
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        return new Object();
    }

    public HashMap<RuneItem, Integer> getRunes() {
        if (this.runes.isEmpty()) {
            this.populateRunes(this.runes);
        }
        return this.runes;
    }

    @Nullable
    public SoundEvent getCastingSound() {
        return null;
    }

    protected abstract void populateRunes(HashMap<RuneItem, Integer> var1);

    public abstract void cast(World var1, ItemStack var2, EntityLivingBase var3, Object var4);

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return repairMaterial.func_77973_b() != Items.field_151134_bR && OreDictionary.itemMatches((ItemStack)repairMaterial, (ItemStack)new ItemStack((Item)ItemRegister.magicRepairDust), (boolean)false);
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        return true;
    }

    @Override
    public EnumHand getWeaponHand() {
        return EnumHand.MAIN_HAND;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public float getDmg() {
        return 0.0f;
    }

    public int func_77619_b() {
        return 8;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventGunProvider();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.getDmg() > 0.0f) {
            tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.magic", Enums.ItemDescriptionType.ITEM_DAMAGE, Float.toString(this.getDmg())));
        }
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.staff.runesRequired", Enums.ItemDescriptionType.ITEM_AMMO_COST));
        for (Map.Entry<RuneItem, Integer> runeEntry : this.getRunes().entrySet()) {
            tooltip.add(StringUtil.getColourLocaleStringWithArguments("items.description.staff.runesRequired.specific", TextFormatting.WHITE, Integer.toString(runeEntry.getValue()), StringUtil.getLocaleString(runeEntry.getKey().func_77658_a() + ".name")));
        }
    }
}

