/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class ConcussionStaff
extends BaseStaff {
    public ConcussionStaff(int durability) {
        super(durability);
        this.func_77655_b("ConcussionStaff");
        this.setRegistryName("aoa3:concussion_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffConcussion;
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        List list = caster.field_70170_p.func_175647_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g(8.0), PredicateUtil.IS_HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runePower, 4);
        runes.put(ItemRegister.runeStorm, 4);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (EntityLivingBase e : (List)args) {
            EntityUtil.pushEntityAway((Entity)caster, (Entity)e, 3.0f);
            WorldUtil.createExplosion((Entity)caster, e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O + 0.5, e.field_70161_v, 2.3f);
            e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 25, 10, true, true));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.ConcussionStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

