/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class CrystalStaff
extends BaseStaff {
    public CrystalStaff(int durability) {
        super(durability);
        this.func_77655_b("CrystalStaff");
        this.setRegistryName("aoa3:crystal_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffCrystevia;
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        List playerList = caster.field_70170_p.func_175647_a(EntityPlayer.class, caster.func_174813_aQ().func_186662_g(20.0), PredicateUtil.IS_VULNERABLE_PLAYER);
        if (playerList.isEmpty()) {
            return null;
        }
        for (EntityPlayer pl : playerList) {
            if (pl.func_110143_aJ() == pl.func_110138_aP()) continue;
            return playerList;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeDistortion, 2);
        runes.put(ItemRegister.runeLife, 5);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        float currentTotalHealth = 0.0f;
        float currentMaxHealth = 0.0f;
        for (EntityPlayer pl : (List)args) {
            currentMaxHealth += pl.func_110138_aP();
            currentTotalHealth += pl.func_110143_aJ();
        }
        float healthPerPlayer = currentMaxHealth * (currentTotalHealth / currentMaxHealth * 1.25f) / (float)((List)args).size();
        for (EntityPlayer pl : (List)args) {
            pl.func_70606_j(healthPerPlayer);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystalStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystalStaff.desc.2", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

