/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class CrystonStaff
extends BaseStaff {
    public CrystonStaff(int durability) {
        super(durability);
        this.func_77655_b("CrystonStaff");
        this.setRegistryName("aoa3:cryston_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffCrystevia;
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        Integer count = caster.field_70170_p.func_175647_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g(10.0), PredicateUtil.IS_HOSTILE_MOB).size();
        if (count > 0) {
            return count;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeDistortion, 2);
        runes.put(ItemRegister.runeEnergy, 4);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        caster.func_70690_d(new PotionEffect(MobEffects.field_76424_c, Math.min((Integer)args * 100, 1200), Math.min(3, (Integer)args) - 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CrystonStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

