/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class FungalStaff
extends BaseStaff {
    public FungalStaff(int durability) {
        super(durability);
        this.func_77655_b("FungalStaff");
        this.setRegistryName("aoa3:fungal_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffFungal;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeDistortion, 5);
        runes.put(ItemRegister.runeLife, 2);
    }

    @Override
    @Nullable
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        HashMap<BlockPos, Boolean> workablePositions = new HashMap<BlockPos, Boolean>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block block = caster.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(caster.field_70165_t + (double)x, caster.field_70163_u + (double)y, caster.field_70161_v + (double)z)).func_177230_c();
                    if (block == Blocks.field_150349_c) {
                        workablePositions.put(checkPos.func_185334_h(), true);
                        continue;
                    }
                    if (!(block instanceof BlockMushroom)) continue;
                    workablePositions.put(checkPos.func_185334_h(), false);
                }
            }
        }
        return workablePositions.isEmpty() ? null : workablePositions;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (Map.Entry entry : ((HashMap)args).entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) {
                world.func_175656_a((BlockPos)entry.getKey(), Blocks.field_150391_bh.func_176223_P());
            } else {
                BlockPos pos = (BlockPos)entry.getKey();
                IBlockState state = world.func_180495_p(pos);
                BlockMushroom mushroom = (BlockMushroom)state.func_177230_c();
                if (mushroom.func_176473_a(world, pos, state, false) && mushroom.func_180670_a(world, field_77697_d, pos, state)) {
                    mushroom.func_176474_b(world, field_77697_d, pos, state);
                }
            }
            world.func_175718_b(2005, (BlockPos)entry.getKey(), 0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.FungalStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.FungalStaff.desc.2", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

