/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class JokerStaff
extends BaseStaff {
    public JokerStaff(int durability) {
        super(durability);
        this.func_77655_b("JokerStaff");
        this.setRegistryName("aoa3:joker_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffJoker;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeWind, 4);
        runes.put(ItemRegister.runeKinetic, 4);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        List list = caster.field_70170_p.func_175647_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g(10.0), PredicateUtil.IS_HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (EntityLivingBase entity : (List)args) {
            if (!EntityUtil.isTypeImmune((Entity)entity, Enums.MobProperties.MAGIC_IMMUNE)) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 100, 5, false, true));
            }
            entity.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 140, 20, true, false));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.JokerStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

