/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityLyonicShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class MechaStaff
extends BaseStaff {
    public MechaStaff(int durability) {
        super(durability);
        this.func_77655_b("MechaStaff");
        this.setRegistryName("aoa3:mecha_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffBasic;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeWind, 2);
        runes.put(ItemRegister.runeDistortion, 1);
        runes.put(ItemRegister.runePower, 1);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        world.func_72838_d((Entity)new EntityLyonicShot(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)target;
            IAttributeInstance armour = entity.func_110148_a(SharedMonsterAttributes.field_188791_g);
            if (armour != null && armour.func_111126_e() > 0.0 && !armour.func_180374_a(AoAAttributes.MECHA_STAFF_DEBUFF)) {
                EntityUtil.applyAttributeModifierSafely(entity, SharedMonsterAttributes.field_188791_g, AoAAttributes.MECHA_STAFF_DEBUFF);
                if (!entity.field_70170_p.field_72995_K) {
                    AxisAlignedBB bounds = entity.func_174813_aQ();
                    for (int i = 0; i < 8; ++i) {
                        ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.TOTEM, bounds.field_72340_a + field_77697_d.nextDouble() * (double)entity.field_70130_N, bounds.field_72337_e + 0.1, bounds.field_72339_c + field_77697_d.nextDouble() * (double)entity.field_70130_N, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.MechaStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

