/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityTangleFall;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class TangleStaff
extends BaseStaff {
    public TangleStaff(int durability) {
        super(durability);
        this.func_77655_b("TangleStaff");
        this.setRegistryName("aoa3:tangle_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffTangle;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeWind, 2);
        runes.put(ItemRegister.runePoison, 2);
        runes.put(ItemRegister.runeStorm, 1);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof EntityPlayer) {
            trace = EntityUtil.getBlockAimingAt((EntityPlayer)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        BlockPos pos = (BlockPos)args;
        for (int i = 0; i < 8; ++i) {
            world.func_72838_d((Entity)new EntityTangleFall(caster, (EnergyProjectileWeapon)this, (float)(pos.func_177958_n() - 4) + field_77697_d.nextFloat() * 8.0f, (double)(pos.func_177956_o() + 30), (double)((float)(pos.func_177952_p() - 4) + field_77697_d.nextFloat() * 8.0f), 3.0f));
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (EntityUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 50, false, true));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 9.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.TangleStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

