/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityUltimatumShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.scheduling.sync.UltimatumStaffTask;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;

public class UltimatumStaff
extends BaseStaff {
    public UltimatumStaff(int durability) {
        super(durability);
        this.func_77655_b("UltimatumStaff");
        this.setRegistryName("aoa3:ultimatum_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.staffUltimatum;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.runeLife, 5);
        runes.put(ItemRegister.runePower, 3);
        runes.put(ItemRegister.runeDistortion, 8);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        world.func_72838_d((Entity)new EntityUltimatumShot(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (target instanceof EntityLivingBase && !EntityUtil.isSpecExempt(target, shooter)) {
            Vec3d lookVec = shooter.func_70040_Z();
            double posX = shooter.field_70165_t + lookVec.field_72450_a * 4.0;
            double posZ = shooter.field_70161_v + lookVec.field_72449_c * 4.0;
            target.func_70080_a(posX, shooter.field_70163_u, posZ, (shooter.field_70759_as + 180.0f) % 360.0f, 0.0f);
            target.func_70034_d((shooter.field_70759_as + 180.0f) % 360.0f);
            target.func_70634_a(posX, shooter.field_70163_u, posZ);
            ModUtil.scheduleSyncronisedTask(new UltimatumStaffTask(shooter, (EntityLivingBase)target), 2);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.UltimatumStaff.desc.1", Enums.ItemDescriptionType.UNIQUE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.damage.specImmune", Enums.ItemDescriptionType.NEGATIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

