/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStack;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackProvider;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public abstract class BaseSword
extends ItemSword
implements AdventWeapon {
    protected final float dmg = this.func_150931_i();
    protected final double speed;

    public BaseSword(Item.ToolMaterial material, double speed) {
        super(material);
        this.speed = speed == 0.0 ? Enums.WeaponSpeed.NORMAL.value : speed;
        this.func_77637_a(CreativeTabsRegister.swordsTab);
    }

    public float getDamage() {
        return this.dmg;
    }

    public double getAttackSpeed() {
        return this.speed;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ((CapabilityBaseMiscStack)stack.getCapability(AdventMiscStackProvider.MISC_STACK, EnumFacing.NORTH)).setValue(player.func_184825_o(0.0f));
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.doMeleeEffect(stack, target, attacker, ((CapabilityBaseMiscStack)stack.getCapability(AdventMiscStackProvider.MISC_STACK, EnumFacing.NORTH)).getValue());
        return super.func_77644_a(stack, target, attacker);
    }

    protected void doMeleeEffect(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker, float attackCooldown) {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new AdventMiscStackProvider();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap modifierMap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            ItemUtil.setAttribute((Multimap<String, AttributeModifier>)modifierMap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.dmg);
            ItemUtil.setAttribute((Multimap<String, AttributeModifier>)modifierMap, SharedMonsterAttributes.field_188790_f, field_185050_h, this.speed);
        }
        return modifierMap;
    }
}

