/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.vulcane;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class BaseVulcane
extends Item
implements AdventWeapon {
    protected double baseDmg;

    public BaseVulcane(double dmg, int durability) {
        this.func_77637_a(CreativeTabsRegister.vulcanesTab);
        this.baseDmg = dmg;
        this.func_77656_e(durability);
        this.func_77664_n();
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public double getDamage() {
        return this.baseDmg;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return repairMaterial.func_77973_b() != Items.field_151134_bR && OreDictionary.itemMatches((ItemStack)repairMaterial, (ItemStack)new ItemStack((Item)ItemRegister.magicRepairDust), (boolean)false);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
        if (!plData.isRevengeActive()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        return this.activate(plData, stack);
    }

    public ActionResult<ItemStack> activate(PlayerDataManager plData, ItemStack vulcane) {
        EntityPlayer pl = plData.player();
        if (EntityUtil.dealVulcaneDamage(plData.getRevengeTarget(), pl, (float)this.baseDmg)) {
            this.doAdditionalEffect(plData.getRevengeTarget(), pl);
            pl.field_70170_p.func_184148_a(null, pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, SoundsRegister.vulcaneUse, SoundCategory.PLAYERS, 1.0f, 1.0f);
            vulcane.func_77972_a(1, (EntityLivingBase)pl);
            plData.disableRevenge();
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)vulcane);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)vulcane);
    }

    public void doAdditionalEffect(EntityLivingBase target, EntityPlayer player) {
    }

    public int func_77619_b() {
        return 8;
    }

    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.true", TextFormatting.DARK_RED, Double.toString(this.baseDmg)));
        tooltip.add(StringUtil.getColourLocaleString("items.description.vulcane.use", TextFormatting.AQUA));
    }
}

