/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class PlayerHasLevel
implements LootCondition {
    private final Enums.Skills skill;
    private final int level;

    public PlayerHasLevel(Enums.Skills skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        return context.func_186495_b() != null && PlayerUtil.getAdventPlayer((EntityPlayer)context.func_186495_b()).stats().getLevel(this.skill) >= this.level;
    }

    public static class Serializer
    extends LootCondition.Serializer<PlayerHasLevel> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_has_level"), PlayerHasLevel.class);
        }

        public void serialize(JsonObject json, PlayerHasLevel value, JsonSerializationContext context) {
            json.addProperty("skill", value.skill.toString().toLowerCase());
            json.addProperty("level", (Number)value.level);
        }

        public PlayerHasLevel deserialize(JsonObject json, JsonDeserializationContext context) {
            return new PlayerHasLevel(Enums.Skills.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"skill").toUpperCase()), JsonUtils.func_151203_m((JsonObject)json, (String)"level"));
        }
    }
}

