/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class GrantXp
extends LootFunction {
    private final Enums.Skills skill;
    private final float xp;

    public GrantXp(LootCondition[] conditionsIn, Enums.Skills skill, float xp) {
        super(conditionsIn);
        this.skill = skill;
        this.xp = xp;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (context.func_186495_b() instanceof EntityPlayer) {
            PlayerUtil.getAdventPlayer((EntityPlayer)context.func_186495_b()).stats().addXp(this.skill, this.xp, false, false);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<GrantXp> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "grant_xp"), GrantXp.class);
        }

        public void serialize(JsonObject json, GrantXp functionInstance, JsonSerializationContext serializationContext) {
            json.addProperty("skill", functionInstance.skill.toString().toLowerCase());
            json.addProperty("xp", (Number)Float.valueOf(functionInstance.xp));
        }

        public GrantXp deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] lootConditions) {
            return new GrantXp(lootConditions, Enums.Skills.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"skill").toUpperCase()), JsonUtils.func_151217_k((JsonObject)json, (String)"xp"));
        }
    }
}

