/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.scheduling.async;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.entity.boss.kror.EntityKror;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class KrorSpawnTask
implements Runnable {
    private final EntityPlayerMP player;
    private final World world;
    private final BlockPos chargingTablePos;
    private int chargedAmount = 0;

    public KrorSpawnTask(EntityPlayerMP player, BlockPos pos) {
        this.player = player;
        this.world = player.field_70170_p;
        this.chargingTablePos = pos;
    }

    @Override
    public void run() {
        if (this.player.field_70170_p != this.world || this.player.func_70011_f((double)this.chargingTablePos.func_177958_n(), (double)this.chargingTablePos.func_177956_o(), (double)this.chargingTablePos.func_177952_p()) > 10.0) {
            this.player.func_145747_a((ITextComponent)StringUtil.getLocale("message.mob.kror.tooFar"));
            return;
        }
        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.spawnBoss.difficultyFail"));
            return;
        }
        if (this.world.func_180495_p(this.chargingTablePos).func_177230_c() != BlockRegister.chargingTable) {
            return;
        }
        if (this.chargedAmount < 200) {
            if (PlayerUtil.consumeResource((EntityPlayer)this.player, Enums.Resources.ENERGY, 20.0f, false)) {
                this.chargedAmount += 20;
                ((WorldServer)this.world).func_175739_a(EnumParticleTypes.END_ROD, (double)this.chargingTablePos.func_177958_n() + 0.5, (double)this.chargingTablePos.func_177956_o() + 0.9, (double)this.chargingTablePos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                ((WorldServer)this.world).func_175739_a(EnumParticleTypes.END_ROD, this.player.field_70165_t, this.player.func_174813_aQ().field_72337_e + 0.5, this.player.field_70161_v, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                this.schedule(1, TimeUnit.SECONDS);
            } else {
                PlayerUtil.notifyPlayerOfInsufficientResources(this.player, Enums.Resources.ENERGY, 20.0f);
            }
        } else {
            EntityKror kror = new EntityKror(this.world);
            int i = 0;
            kror.func_70107_b((double)this.chargingTablePos.func_177958_n() - 0.5, this.chargingTablePos.func_177956_o(), (double)this.chargingTablePos.func_177952_p() - 0.5 + 10.0);
            while (this.world.func_72829_c(kror.func_174813_aQ())) {
                Random rand = kror.func_70681_au();
                kror.func_70107_b(kror.field_70165_t + (double)rand.nextInt(20) - 10.0, kror.field_70163_u, kror.field_70161_v + (double)rand.nextInt(20) - 10.0);
                if (++i <= 64) continue;
                this.player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.spawnBoss.noSpace"));
                return;
            }
            StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.kror.spawn", this.player.getDisplayNameString()), (Entity)this.player, 50);
            this.world.func_72838_d((Entity)kror);
            kror.func_70624_b((EntityLivingBase)this.player);
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        ModUtil.scheduleRequiredAsyncTask(this, time, units);
    }
}

