/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.FluidsRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.OreDictUtil;
import net.tslat.aoa3.utils.skills.HunterUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ModUtil {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final HashSet<Runnable> scheduledTasks = new HashSet();
    private static final HashMultimap<Integer, Runnable> scheduledSynchTasks = HashMultimap.create();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();

    public static void scrapeRegistries() {
        OreDictUtil.addDefaultEntries();
        AdventOfAscension.logOptionalMessage("Applying hunter statuses");
        for (String entry : ConfigurationUtil.EntityConfig.hunterEntities.hunterEntities) {
            String[] entryParts = entry.split(" ");
            if (entryParts.length < 3) {
                AdventOfAscension.logOptionalMessage("Invalid format for hunter entity entry: \"" + entry + "\"");
                continue;
            }
            try {
                String registryName = entryParts[0];
                int levelReq = MathHelper.func_76125_a((int)Integer.parseInt(entryParts[1].replace("lvl:", "")), (int)1, (int)100);
                float hunterXp = MathHelper.func_76131_a((float)Float.parseFloat(entryParts[2].replace("xp:", "")), (float)0.0f, (float)Float.MAX_VALUE);
                EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(registryName));
                if (entityEntry == null) {
                    AdventOfAscension.logOptionalMessage("Unable to find entity registered as: \"" + registryName + "\"");
                    continue;
                }
                Class entityClass = entityEntry.getEntityClass();
                if (EntityLivingBase.class.isAssignableFrom(entityClass)) {
                    HunterUtil.registerHunterCreature(entityClass, levelReq, hunterXp);
                    AdventOfAscension.logOptionalMessage("Registered hunter entity: " + registryName + " , Lvl: " + levelReq + ", Xp: " + hunterXp);
                    continue;
                }
                AdventOfAscension.logOptionalMessage("Entity \"" + registryName + "\" is does not extend EntityLivingBase. Hunter entities must be alive to apply");
            }
            catch (NumberFormatException ex) {
                AdventOfAscension.logOptionalMessage("Invalid format for value: \"" + entryParts[1] + "\"", ex);
            }
        }
        AdventOfAscension.logOptionalMessage("Patching entity stats overrides");
        for (String string : ConfigurationUtil.EntityConfig.entityStats.entityStats) {
        }
    }

    public static void modConstructTasks() {
        FluidRegistry.enableUniversalBucket();
    }

    public static void preInitTasks() {
        ModUtil.patchMaxHP();
        FluidsRegister.registerFluids();
    }

    private static void patchMaxHP() {
        AdventOfAscension.logOptionalMessage("Patching out vanilla max HP attribute");
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)SharedMonsterAttributes.field_111267_a, (Object)Double.MAX_VALUE, (int)1);
    }

    public static void scheduleRequiredAsyncTask(Runnable run, int time, TimeUnit unit) {
        scheduler.schedule(run, (long)time, unit);
        scheduledTasks.add(run);
    }

    public static void scheduleSyncronisedTask(Runnable run, int ticks) {
        scheduledSynchTasks.put((Object)(GlobalEvents.tick + ticks), (Object)run);
    }

    public static void scheduleAsyncTask(Runnable run, int time, TimeUnit unit) {
        scheduler.schedule(run, (long)time, unit);
    }

    public static void serverShutdownTasks() {
        for (Runnable task : scheduledTasks) {
            task.run();
        }
        AdventOfAscension.proxy.worldShutdown();
    }

    public static void handleSyncScheduledTasks(int tick) {
        if (scheduledSynchTasks.containsKey((Object)tick)) {
            Iterator tasks = scheduledSynchTasks.get((Object)tick).iterator();
            while (tasks.hasNext()) {
                ((Runnable)tasks.next()).run();
                tasks.remove();
            }
        }
    }

    public static Advancement getAdvancement(String resourcePath) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192778_a(new ResourceLocation("aoa3", resourcePath));
    }

    public static boolean completeAdvancement(EntityPlayerMP player, String resourcePath, String criterion) {
        Advancement adv = ModUtil.getAdvancement(resourcePath);
        if (adv != null) {
            return player.func_192039_O().func_192750_a(adv, criterion);
        }
        return false;
    }

    public static boolean checkAdvancementCompleted(EntityPlayerMP player, String resourcePath) {
        Advancement adv = ModUtil.getAdvancement(resourcePath);
        if (adv != null) {
            return player.func_192039_O().func_192747_a(adv).func_192105_a();
        }
        return false;
    }

    public static LootPool generateLootPoolFromResourceLocation(String poolName, ResourceLocation resource) {
        return new LootPool(new LootEntry[]{new LootEntryTable(resource, 1, 0, new LootCondition[0], poolName)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), poolName);
    }

    public static void replaceAndMergeLootTables(LootTableLoadEvent ev, ResourceLocation lootTableToMergeIn) {
        LootTable newTable = null;
        URL resourceURL = LootSystemRegister.class.getResource("/assets/" + lootTableToMergeIn.func_110624_b() + "/loot_tables/" + lootTableToMergeIn.func_110623_a() + ".json");
        if (resourceURL != null) {
            try {
                String jsonString = Resources.toString((URL)resourceURL, (Charset)StandardCharsets.UTF_8);
                newTable = ForgeHooks.loadLootTable((Gson)gson, (ResourceLocation)lootTableToMergeIn, (String)jsonString, (boolean)true, (LootTableManager)ev.getLootTableManager());
            }
            catch (JsonParseException | IOException e) {
                AdventOfAscension.logMessage(Level.WARN, "Couldn't load loot table " + lootTableToMergeIn.toString() + " from " + resourceURL.toString());
                e.printStackTrace();
            }
            if (newTable == null) {
                return;
            }
            List frozenPools = (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)newTable, (String)"field_186466_c");
            List existingPools = (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)ev.getTable(), (String)"field_186466_c");
            ReflectionHelper.setPrivateValue(LootTable.class, (Object)newTable, (Object)false, (String[])new String[]{"isFrozen"});
            for (LootPool pool : frozenPools) {
                if (!pool.isFrozen()) continue;
                ReflectionHelper.setPrivateValue(LootPool.class, (Object)pool, (Object)false, (String[])new String[]{"isFrozen"});
            }
            for (LootPool pool : existingPools) {
                if (pool.getName().equals("main")) continue;
                newTable.addPool(pool);
            }
            ev.setTable(newTable);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String getTextFromResourceFile(ResourceLocation resourceLocation, String fileType, ResourceLocation ... fallbackLocations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static float[] initFixedArray(float size) {
        return new float[(int)size];
    }

    public static void doDebuggingPrintout(Logger logger) {
        Runtime runtime = Runtime.getRuntime();
        logger.log(Level.INFO, "RAM Usage: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000000L + "MB/" + runtime.totalMemory() / 1000000L + "MB (" + runtime.maxMemory() / 1000000L + "MB max)");
        logger.log(Level.INFO, "Forge Version: " + ForgeVersion.getVersion());
        logger.log(Level.INFO, "Minecraft Version: 1.12.2");
        logger.log(Level.INFO, "Mod Version: 3.2.7");
        logger.log(Level.INFO, "Total blocks registered: " + ForgeRegistries.BLOCKS.getValuesCollection().size());
        logger.log(Level.INFO, "Total items registered: " + ForgeRegistries.ITEMS.getValuesCollection().size());
        logger.log(Level.INFO, "Total potions registered: " + ForgeRegistries.POTIONS.getValuesCollection().size());
        logger.log(Level.INFO, "Total biomes registered: " + ForgeRegistries.BIOMES.getValuesCollection().size());
        logger.log(Level.INFO, "Total entities registered: " + ForgeRegistries.ENTITIES.getValuesCollection().size());
        logger.log(Level.INFO, "Total enchantments registered: " + ForgeRegistries.ENTITIES.getValuesCollection().size());
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    private static /* synthetic */ void lambda$getTextFromResourceFile$0(StringBuilder content, String line) {
        content.append(line);
        content.append("\n");
    }
}

