/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils.player;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.packet.PacketResourceData;
import net.tslat.aoa3.common.packet.PacketSkillData;
import net.tslat.aoa3.common.packet.PacketTributeData;
import net.tslat.aoa3.common.packet.PacketXpGain;
import net.tslat.aoa3.common.registration.AdvancementTriggerRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.event.AoAEvents;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.leaderboard.AoALeaderboard;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.library.misc.PortalCoordinatesContainer;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;
import net.tslat.aoa3.utils.skills.AuguryUtil;
import net.tslat.aoa3.utils.skills.ButcheryUtil;
import net.tslat.aoa3.utils.skills.InnervationUtil;
import org.apache.logging.log4j.Level;

public final class PlayerDataManager {
    private final EntityPlayer player;
    private int nextEnergyRegenTime = 0;
    private int nextRageRegenTime = 0;
    private int revengeTimer = 0;
    private EntityLivingBase revengeTarget;
    private HashMap<Integer, PortalCoordinatesContainer> portalCoordinatesMap = new HashMap();
    private HashSet<ItemStack> interventionData = null;
    private final PlayerEquipment equipment;
    private final PlayerStats stats;
    private final PlayerBuffs buffs;
    private int nextMessageTime = 0;
    private TextComponentTranslation lastMessage = new TextComponentTranslation("init", new Object[0]);
    private boolean resourcesUpdated = false;

    public PlayerDataManager(EntityPlayer player) {
        this.player = player;
        this.equipment = new PlayerEquipment(this);
        this.stats = new PlayerStats(this);
        this.buffs = new PlayerBuffs();
    }

    public EntityPlayer player() {
        return this.player;
    }

    public PlayerEquipment equipment() {
        return this.equipment;
    }

    public PlayerStats stats() {
        return this.stats;
    }

    public PlayerBuffs buffs() {
        return this.buffs;
    }

    public void tickPlayer() {
        if (this.player == null || this.player.func_175149_v() || this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.equipment.handleEquipmentCheck(this);
        this.equipment.tickEquipment(this);
        this.stats.regenResources();
        this.stats.doTributeBuffs();
        if (this.revengeTimer > 0) {
            --this.revengeTimer;
            if (this.revengeTimer == 0) {
                this.disableRevenge();
            }
        }
        if (this.resourcesUpdated && this.player instanceof EntityPlayerMP) {
            PacketUtil.network.sendTo((IMessage)new PacketResourceData(((Float)this.stats.resources.get((Object)Enums.Resources.CREATION)).floatValue(), ((Float)this.stats.resources.get((Object)Enums.Resources.ENERGY)).floatValue(), ((Float)this.stats.resources.get((Object)Enums.Resources.RAGE)).floatValue(), ((Float)this.stats.resources.get((Object)Enums.Resources.SOUL)).floatValue(), this.isRevengeActive()), (EntityPlayerMP)this.player);
        }
    }

    public void sendThrottledChatMessage(String langKey, Object ... args) {
        Style style = null;
        int styleArgs = 0;
        for (Object arg : args) {
            if (arg.getClass() != TextFormatting.class) continue;
            if (style == null) {
                style = new Style();
            }
            switch ((TextFormatting)arg) {
                case UNDERLINE: {
                    style.func_150228_d(Boolean.valueOf(true));
                    break;
                }
                case RESET: {
                    break;
                }
                case ITALIC: {
                    style.func_150217_b(Boolean.valueOf(true));
                    break;
                }
                case STRIKETHROUGH: {
                    style.func_150225_c(Boolean.valueOf(true));
                    break;
                }
                case BOLD: {
                    style.func_150227_a(Boolean.valueOf(true));
                    break;
                }
                case OBFUSCATED: {
                    style.func_150237_e(Boolean.valueOf(true));
                    break;
                }
                default: {
                    style.func_150238_a((TextFormatting)arg);
                }
            }
            ++styleArgs;
        }
        Object[] arguments = new Object[args.length - styleArgs];
        int i = 0;
        for (Object arg : args) {
            if (arg.getClass() == TextFormatting.class) continue;
            arguments[i] = arg;
            ++i;
        }
        TextComponentTranslation message = new TextComponentTranslation(langKey, arguments);
        if (style != null) {
            message.func_150255_a(style);
        }
        if (message.equals((Object)this.lastMessage) && (this.nextMessageTime > GlobalEvents.tick || GlobalEvents.tick + 300 < this.nextMessageTime)) {
            return;
        }
        this.nextMessageTime = GlobalEvents.tick + 200;
        this.lastMessage = message;
        this.player.func_145747_a((ITextComponent)message);
    }

    private void storeInterventionItems() {
        ItemStack stack;
        int i;
        if (this.interventionData == null) {
            this.interventionData = new HashSet();
        }
        for (i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            stack = this.player.field_71071_by.func_70301_a(i);
            if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.intervention, (ItemStack)stack) <= 0) continue;
            if (AdventOfAscension.rand.nextInt(5) == 0) {
                stack = ItemUtil.removeEnchantment(stack, EnchantmentsRegister.intervention);
            }
            this.interventionData.add(stack);
            this.player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < 4; ++i) {
            stack = (ItemStack)this.player.field_71071_by.field_70460_b.get(i);
            if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.intervention, (ItemStack)stack) <= 0) continue;
            if (AdventOfAscension.rand.nextInt(5) == 0) {
                stack = ItemUtil.removeEnchantment(stack, EnchantmentsRegister.intervention);
            }
            this.interventionData.add(stack);
            this.player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private void retrieveInterventionItems() {
        if (this.interventionData != null) {
            for (ItemStack stack : this.interventionData) {
                ItemUtil.givePlayerItemOrDrop(this.player, stack);
            }
            this.interventionData = null;
        }
    }

    public void storeInterventionItem(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (this.interventionData == null) {
            this.interventionData = new HashSet();
        }
        this.interventionData.add(stack);
    }

    public void setPortalReturnLocation(Integer toDimId, PortalCoordinatesContainer coords) {
        this.portalCoordinatesMap.put(toDimId, coords);
    }

    public void removePortalReturnLocation(Integer toDimId) {
        this.portalCoordinatesMap.remove(toDimId);
    }

    public void flushPortalReturnLocations() {
        this.portalCoordinatesMap.clear();
    }

    public PortalCoordinatesContainer getPortalReturnLocation(Integer toDimId) {
        return this.portalCoordinatesMap.get(toDimId);
    }

    public void handleIncomingAttack(LivingAttackEvent ev) {
        if (!ev.isCanceled()) {
            this.equipment.handleIncomingAttack(ev);
        }
    }

    public void handleIncomingDamage(LivingHurtEvent ev) {
        if (!ev.isCanceled()) {
            this.equipment.handleIncomingDamage(ev);
        }
    }

    public void handleOutgoingDamage(LivingHurtEvent ev) {
        if (!ev.isCanceled()) {
            this.equipment.handleOutgoingDamage(ev);
        }
    }

    public void handleDamageTriggers(LivingDamageEvent ev) {
        if (!ev.isCanceled()) {
            this.equipment.handleDamageTriggers(ev);
        }
    }

    public void handlePlayerFalling(LivingFallEvent ev) {
        if (!ev.isCanceled()) {
            this.equipment.handlePlayerFalling(ev);
        }
    }

    public void handlePlayerDeath(LivingDeathEvent ev) {
        this.equipment.handlePlayerDeath(ev);
        this.storeInterventionItems();
        if (ConfigurationUtil.MainConfig.funOptions.hardcoreMode) {
            for (Enums.Skills skill : Enums.Skills.values()) {
                this.stats.levels.put(skill, Math.max(1, (Integer)this.stats.levels.get((Object)skill) - 1));
            }
        }
    }

    public void handlePlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        this.retrieveInterventionItems();
    }

    private void checkAndUpdateLegitimacy() {
        if (this.player instanceof EntityPlayerMP) {
            Advancement adv = ModUtil.getAdvancement("overworld/by_the_books");
            boolean legit = ((EntityPlayerMP)this.player).func_192039_O().func_192747_a(adv).func_192105_a();
            PlayerAdvancements plAdv = ((EntityPlayerMP)this.player).func_192039_O();
            int opt = (Integer)this.stats.optionals.get((Object)Enums.Skills.EXPEDITION);
            if (opt > 3 && legit) {
                plAdv.func_192744_b(adv, "legitimate");
            } else if (!legit) {
                Advancement rootAdv = ModUtil.getAdvancement("overworld/root");
                if (!plAdv.func_192747_a(rootAdv).func_192105_a()) {
                    plAdv.func_192750_a(rootAdv, "playerjoin");
                    plAdv.func_192750_a(adv, "legitimate");
                } else {
                    this.stats.optionals.put(Enums.Skills.EXPEDITION, opt % 4 + 4);
                }
            }
        }
    }

    private void applyLegitimacyPenalties() {
        this.stats.optionals.put(Enums.Skills.EXPEDITION, (Integer)this.stats.optionals.get((Object)Enums.Skills.EXPEDITION) % 4 + 4);
        AoALeaderboard.removePlayer(this.player);
        if (this.player instanceof EntityPlayerMP) {
            Advancement byTheBooksAdv = FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192778_a(new ResourceLocation("aoa3", "overworld/by_the_books"));
            if (byTheBooksAdv != null) {
                ((EntityPlayerMP)this.player).func_192039_O().func_192744_b(byTheBooksAdv, "legitimate");
            }
            PacketUtil.network.sendTo((IMessage)new PacketSkillData(Enums.Skills.EXPEDITION.id, (Integer)this.stats.levels.get((Object)Enums.Skills.EXPEDITION), ((Float)this.stats.xp.get((Object)Enums.Skills.EXPEDITION)).floatValue(), (Integer)this.stats.optionals.get((Object)Enums.Skills.EXPEDITION)), (EntityPlayerMP)this.player);
        }
    }

    public void enableRevenge(EntityLivingBase target) {
        this.revengeTimer = 400;
        this.revengeTarget = target;
        this.resourcesUpdated = true;
    }

    public boolean isRevengeActive() {
        return this.revengeTimer > 0 && this.revengeTarget != null;
    }

    public void disableRevenge() {
        this.revengeTimer = 0;
        this.revengeTarget = null;
        this.resourcesUpdated = true;
    }

    public EntityLivingBase getRevengeTarget() {
        return this.revengeTarget;
    }

    void cloneFromExistingPlayerData(PlayerDataManager sourcePlayerData) {
        this.interventionData = sourcePlayerData.interventionData;
        for (Enums.Skills skill : Enums.Skills.values()) {
            this.stats.levels.put(skill, sourcePlayerData.stats.levels.get((Object)skill));
            this.stats.xp.put(skill, Float.valueOf(sourcePlayerData.stats.getExp(skill)));
        }
        for (Map.Entry entry : sourcePlayerData.stats.optionals.entrySet()) {
            this.stats.optionals.put(entry.getKey(), entry.getValue());
        }
        for (Enums.Deities deity : Enums.Deities.values()) {
            this.stats.tribute.put(deity, sourcePlayerData.stats.tribute.get((Object)deity));
        }
        this.equipment.cooldowns = sourcePlayerData.equipment.cooldowns;
        this.portalCoordinatesMap = sourcePlayerData.portalCoordinatesMap;
        EntityUtil.applyAttributeModifierSafely((EntityLivingBase)this.player, SharedMonsterAttributes.field_111267_a, AoAAttributes.innervationHealthBuff(InnervationUtil.getHealthBuff(this.stats.getLevel(Enums.Skills.INNERVATION))));
        this.player.func_70606_j(this.player.func_110138_aP());
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound baseTag = new NBTTagCompound();
        this.stats.saveToNBT(baseTag);
        if (!this.portalCoordinatesMap.isEmpty()) {
            NBTTagCompound portalCoordinatesNBT = new NBTTagCompound();
            for (Map.Entry<Integer, PortalCoordinatesContainer> entry : this.portalCoordinatesMap.entrySet()) {
                NBTTagCompound portalReturnTag = new NBTTagCompound();
                PortalCoordinatesContainer container = entry.getValue();
                portalReturnTag.func_74768_a("FromDim", container.fromDim);
                portalReturnTag.func_74780_a("PosX", container.x);
                portalReturnTag.func_74780_a("PosY", container.y);
                portalReturnTag.func_74780_a("PosZ", container.z);
                portalCoordinatesNBT.func_74782_a(entry.getKey().toString(), (NBTBase)portalReturnTag);
            }
            baseTag.func_74782_a("PortalMap", (NBTBase)portalCoordinatesNBT);
        }
        return baseTag;
    }

    public void loadFromNBT(NBTTagCompound baseTag) {
        this.stats.loadFromNBT(baseTag);
        if (baseTag.func_74764_b("PortalMap")) {
            NBTTagCompound portalMapTag = baseTag.func_74775_l("PortalMap");
            for (String s : portalMapTag.func_150296_c()) {
                NBTTagCompound portalReturnTag = portalMapTag.func_74775_l(s);
                int fromDim = portalReturnTag.func_74762_e("FromDim");
                double x = portalReturnTag.func_74769_h("PosX");
                double y = portalReturnTag.func_74769_h("PosY");
                double z = portalReturnTag.func_74769_h("PosZ");
                try {
                    this.portalCoordinatesMap.put(Integer.valueOf(s), new PortalCoordinatesContainer(fromDim, x, y, z));
                }
                catch (NumberFormatException e) {
                    AdventOfAscension.logMessage(Level.WARN, "Found invalid portal map data, has someone been tampering with files? Data: " + s);
                }
            }
        }
        this.checkAndUpdateLegitimacy();
    }

    public static final class PlayerBuffs {
        private HashMap<String, Float> defensiveBuffs = null;
        private HashMap<String, Float> offensiveBuffs = null;
        private HashMap<String, Float> miscBuffs = null;
        private float globalXpMod = 1.0f;
        private HashMap<Enums.Skills, Float> xpMods = null;
        private HashMap<Enums.Resources, Float> resourceRegenBuffs = null;
        private HashMap<Enums.Resources, Float> resourceFortitudeBuffs = null;

        private void applyDefensiveBuffs(LivingHurtEvent ev) {
            if (this.defensiveBuffs != null && this.defensiveBuffs.containsKey(ev.getSource().func_76355_l())) {
                ev.setAmount(ev.getAmount() * (1.0f - this.defensiveBuffs.get(ev.getSource().func_76355_l()).floatValue()));
            }
        }

        private void applyOffensiveBuffs(LivingHurtEvent ev) {
            if (this.offensiveBuffs != null && this.offensiveBuffs.containsKey(ev.getSource().func_76355_l())) {
                ev.setAmount(ev.getAmount() * (1.0f + this.offensiveBuffs.get(ev.getSource().func_76355_l()).floatValue()));
            }
        }

        private float applyXpBuffs(Enums.Skills skill, float baseXp) {
            baseXp *= this.globalXpMod;
            if (this.xpMods != null && this.xpMods.containsKey((Object)skill)) {
                baseXp *= 1.0f + this.xpMods.get((Object)skill).floatValue();
            }
            return baseXp;
        }

        private float applyResourceRegenBuffs(Enums.Resources resource, float amountToRegen) {
            if (this.resourceRegenBuffs != null && this.resourceRegenBuffs.containsKey((Object)resource)) {
                amountToRegen *= 1.0f + this.resourceRegenBuffs.get((Object)resource).floatValue();
            }
            return amountToRegen;
        }

        private float applyResourceFortitudeBuffs(Enums.Resources resource, float amountToConsume) {
            if (this.resourceFortitudeBuffs != null && this.resourceFortitudeBuffs.containsKey((Object)resource)) {
                amountToConsume *= 1.0f - this.resourceFortitudeBuffs.get((Object)resource).floatValue();
            }
            return amountToConsume;
        }

        public void addDefensiveBuff(String damageType, float modifier) {
            if (this.defensiveBuffs == null) {
                this.defensiveBuffs = new HashMap(2);
            }
            this.defensiveBuffs.merge(damageType, Float.valueOf(modifier), Float::sum);
        }

        public void addOffensiveBuff(String damageType, float modifier) {
            if (this.offensiveBuffs == null) {
                this.offensiveBuffs = new HashMap(2);
            }
            this.offensiveBuffs.merge(damageType, Float.valueOf(modifier), Float::sum);
        }

        public void removeDefensiveBuff(String damageType, float modifier) {
            if (this.defensiveBuffs != null) {
                this.defensiveBuffs.merge(damageType, Float.valueOf(modifier), (key, value) -> {
                    value = Float.valueOf(value.floatValue() - (modifier == 0.0f ? null : value).floatValue());
                    return value;
                });
                if (this.defensiveBuffs.get(damageType).floatValue() == 0.0f) {
                    this.defensiveBuffs.remove(damageType);
                }
            }
        }

        public void removeOffensiveBuff(String damageType, float modifier) {
            if (this.offensiveBuffs != null) {
                this.offensiveBuffs.merge(damageType, Float.valueOf(modifier), (key, value) -> {
                    value = Float.valueOf(value.floatValue() - (modifier == 0.0f ? null : value).floatValue());
                    return value;
                });
                if (this.offensiveBuffs.get(damageType).floatValue() == 0.0f) {
                    this.offensiveBuffs.remove(damageType);
                }
            }
        }

        public void addMiscBuff(String buffName, float modifier) {
            if (this.miscBuffs == null) {
                this.miscBuffs = new HashMap(2);
            }
            this.miscBuffs.merge(buffName, Float.valueOf(modifier), Float::sum);
        }

        public void removeMiscBuff(String buffName, float modifier) {
            if (this.miscBuffs != null) {
                this.miscBuffs.merge(buffName, Float.valueOf(modifier), (key, value) -> {
                    value = Float.valueOf(value.floatValue() - (modifier == 0.0f ? null : value).floatValue());
                    return value;
                });
                if (this.miscBuffs.get(buffName).floatValue() == 0.0f) {
                    this.miscBuffs.remove(buffName);
                }
            }
        }

        public void addGlobalXpModifier(float modifier) {
            this.globalXpMod += modifier;
        }

        public void removeGlobalXpModifier(float modifier) {
            this.globalXpMod -= modifier;
        }

        public void addXpModifier(Enums.Skills skill, float modifier) {
            if (this.xpMods == null) {
                this.xpMods = new HashMap(2);
            }
            this.xpMods.merge(skill, Float.valueOf(modifier), Float::sum);
        }

        public void removeXpModifier(Enums.Skills skill, float modifier) {
            if (this.xpMods != null) {
                this.xpMods.merge(skill, Float.valueOf(modifier), (key, value) -> {
                    value = Float.valueOf(value.floatValue() - (modifier == 0.0f ? null : value).floatValue());
                    return value;
                });
                if (this.xpMods.get((Object)skill).floatValue() == 0.0f) {
                    this.xpMods.remove((Object)skill);
                }
            }
        }

        public void addResourceRegenModifier(Enums.Resources resource, float modifier) {
            if (this.resourceRegenBuffs == null) {
                this.resourceRegenBuffs = new HashMap(2);
            }
            this.resourceRegenBuffs.merge(resource, Float.valueOf(modifier), Float::sum);
        }

        public void removeResourceRegenModifier(Enums.Resources resource, float modifier) {
            if (this.resourceRegenBuffs != null) {
                this.resourceRegenBuffs.merge(resource, Float.valueOf(modifier), (key, value) -> {
                    value = Float.valueOf(value.floatValue() - (modifier == 0.0f ? null : value).floatValue());
                    return value;
                });
                if (this.resourceRegenBuffs.get((Object)resource).floatValue() == 0.0f) {
                    this.resourceRegenBuffs.remove((Object)resource);
                }
            }
        }

        public void addResourceFortitudeModifier(Enums.Resources resource, float modifier) {
            if (this.resourceFortitudeBuffs == null) {
                this.resourceFortitudeBuffs = new HashMap(2);
            }
            this.resourceFortitudeBuffs.merge(resource, Float.valueOf(modifier), Float::sum);
        }

        public void removeResourceFortitudeModifier(Enums.Resources resource, float modifier) {
            if (this.resourceFortitudeBuffs != null) {
                this.resourceFortitudeBuffs.merge(resource, Float.valueOf(modifier), (key, value) -> {
                    value = Float.valueOf(value.floatValue() - (modifier == 0.0f ? null : value).floatValue());
                    return value;
                });
                if (this.resourceFortitudeBuffs.get((Object)resource).floatValue() == 0.0f) {
                    this.resourceFortitudeBuffs.remove((Object)resource);
                }
            }
        }
    }

    public final class PlayerStats {
        private final PlayerDataManager playerDataManager;
        private HashMap<Enums.Skills, Float> xp = new HashMap(Enums.Skills.values().length);
        private HashMap<Enums.Skills, Integer> levels = new HashMap(Enums.Skills.values().length);
        private HashMap<Enums.Skills, Integer> optionals = new HashMap(1);
        private HashMap<Enums.Deities, Integer> tribute = new HashMap(Enums.Deities.values().length);
        private HashMap<Enums.Resources, Float> resources = new HashMap(Enums.Resources.values().length);

        private PlayerStats(PlayerDataManager dataManager) {
            this.playerDataManager = dataManager;
            for (Enums.Skills skills : Enums.Skills.values()) {
                this.xp.put(skills, Float.valueOf(0.0f));
                this.levels.put(skills, 1);
            }
            for (Enum enum_ : Enums.Deities.values()) {
                this.tribute.put((Enums.Deities)enum_, 0);
            }
            for (Enum enum_ : Enums.Resources.values()) {
                this.resources.put((Enums.Resources)enum_, Float.valueOf(0.0f));
            }
            this.optionals.put(Enums.Skills.EXPEDITION, 1);
        }

        private void regenResources() {
            if (this.resources.get((Object)Enums.Resources.ENERGY).floatValue() < 200.0f && (PlayerDataManager.this.nextEnergyRegenTime < GlobalEvents.tick || GlobalEvents.tick + 60 < PlayerDataManager.this.nextEnergyRegenTime)) {
                this.regenResource(Enums.Resources.ENERGY, 0.32f);
            }
            if (this.resources.get((Object)Enums.Resources.CREATION).floatValue() < AuguryUtil.getMaxCreation(this.levels.get((Object)Enums.Skills.AUGURY))) {
                this.regenResource(Enums.Resources.CREATION, 0.033f);
            }
            if (this.resources.get((Object)Enums.Resources.RAGE).floatValue() < 200.0f && (PlayerDataManager.this.nextRageRegenTime < GlobalEvents.tick || GlobalEvents.tick + 120 < PlayerDataManager.this.nextRageRegenTime)) {
                this.regenResource(Enums.Resources.RAGE, ButcheryUtil.getTickRegen(this.levels.get((Object)Enums.Skills.BUTCHERY)));
            }
            if (this.resources.get((Object)Enums.Resources.SOUL).floatValue() < AuguryUtil.getMaxSoul(this.levels.get((Object)Enums.Skills.AUGURY))) {
                this.regenResource(Enums.Resources.SOUL, 0.01f);
            }
        }

        private void doTributeBuffs() {
            if (((PlayerDataManager)PlayerDataManager.this).player.field_70170_p.field_73011_w.getDimension() == 0 && !((PlayerDataManager)PlayerDataManager.this).player.field_70170_p.func_72935_r()) {
                if (this.tribute.get((Object)Enums.Deities.LUXON) == 200) {
                    PlayerDataManager.this.player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 5, 0, true, false));
                }
                if (this.tribute.get((Object)Enums.Deities.EREBON) == 200) {
                    PlayerDataManager.this.player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, -1, 0, true, false));
                }
                if (this.tribute.get((Object)Enums.Deities.PLUTON) == 200) {
                    PlayerDataManager.this.player.func_70690_d(new PotionEffect(MobEffects.field_188425_z, -1, 1, true, false));
                }
                if (this.tribute.get((Object)Enums.Deities.SELYAN) == 200) {
                    PlayerDataManager.this.player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, -1, 0, true, false));
                }
            }
        }

        public int getLevel(Enums.Skills skill) {
            return Math.min(100, this.levels.get((Object)skill));
        }

        public int getLevelForDisplay(Enums.Skills skill) {
            return this.levels.get((Object)skill);
        }

        public float getExp(Enums.Skills skill) {
            return this.xp.get((Object)skill).floatValue();
        }

        public float getResourceValue(Enums.Resources resource) {
            return this.resources.get((Object)resource).floatValue();
        }

        public int getTribute(Enums.Deities deity) {
            return this.tribute.get((Object)deity);
        }

        @Nullable
        public Integer getSkillData(Enums.Skills skill) {
            return this.optionals.get((Object)skill);
        }

        public void addXp(Enums.Skills skill, float xp, boolean isUnnatural, boolean ignoreXpBuffs) {
            int lvl = this.levels.get((Object)skill);
            if (lvl >= 1000) {
                return;
            }
            if (!isUnnatural) {
                xp = PlayerDataManager.this.buffs.applyXpBuffs(skill, xp);
            }
            float remaining = Math.min(5.4413235E8f, xp);
            int newLevels = 0;
            boolean noXpDrop = !ConfigurationUtil.MainConfig.showVanityLevels && lvl >= 100;
            float xpRemaining = PlayerUtil.getXpRemainingUntilLevel(this.playerDataManager, skill);
            if (remaining > xpRemaining) {
                remaining -= xpRemaining;
                ++newLevels;
                while (true) {
                    float f;
                    float stillRemaining = remaining - PlayerUtil.getXpRequiredForNextLevel(lvl + newLevels);
                    if (!(f >= 0.0f) || lvl + newLevels >= 1000) break;
                    remaining = stillRemaining;
                    ++newLevels;
                }
            }
            if (newLevels > 0) {
                this.levelUp(skill, lvl, lvl + newLevels, !isUnnatural);
                if (!isUnnatural && this.optionals.get((Object)Enums.Skills.EXPEDITION) < 4) {
                    AoALeaderboard.updatePlayerStat(PlayerDataManager.this.player, skill, this.levels.get((Object)skill));
                }
            }
            if (isUnnatural) {
                PlayerDataManager.this.applyLegitimacyPenalties();
            } else if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                AdvancementTriggerRegister.xpGainTrigger.trigger((EntityPlayerMP)PlayerDataManager.this.player, skill, (int)xp);
            }
            this.xp.put(skill, Float.valueOf(this.xp.get((Object)skill).floatValue() + remaining));
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PlayerDataManager.this.checkAndUpdateLegitimacy();
                PacketUtil.network.sendTo((IMessage)new PacketSkillData(skill.id, this.levels.get((Object)skill), this.xp.get((Object)skill).floatValue(), this.optionals.get((Object)skill)), (EntityPlayerMP)PlayerDataManager.this.player);
                if (!noXpDrop) {
                    PacketUtil.network.sendTo((IMessage)new PacketXpGain(skill.id, xp, newLevels > 0), (EntityPlayerMP)PlayerDataManager.this.player);
                }
            }
        }

        public void subtractXp(Enums.Skills skill, float xp) {
            int lvl = this.levels.get((Object)skill);
            float remaining = Math.min(5.4413235E8f, xp);
            int newLevels = 0;
            if (lvl > 1 && remaining > this.xp.get((Object)skill).floatValue()) {
                remaining -= this.xp.get((Object)skill).floatValue();
                ++newLevels;
                while (true) {
                    float f;
                    float stillRemaining = remaining - PlayerUtil.getXpRequiredForNextLevel(lvl - newLevels - 1);
                    if (!(f >= 0.0f) || lvl - newLevels <= 1) break;
                    remaining = stillRemaining;
                    ++newLevels;
                }
            }
            if (newLevels > 0) {
                this.levels.put(skill, lvl - newLevels);
                AoAEvents.playerLevelChange(this.playerDataManager, lvl, lvl - newLevels, skill, false);
            }
            this.xp.put(skill, Float.valueOf(Math.max(0.0f, PlayerUtil.getXpRequiredForNextLevel(lvl - newLevels) - remaining)));
            PlayerDataManager.this.applyLegitimacyPenalties();
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketSkillData(skill.id, this.levels.get((Object)skill), this.xp.get((Object)skill).floatValue(), this.optionals.get((Object)skill)), (EntityPlayerMP)PlayerDataManager.this.player);
            }
        }

        public void levelUp(Enums.Skills skill, int oldLevel, int newLevel, boolean isNaturalLevel) {
            if (newLevel < 100) {
                ((PlayerDataManager)PlayerDataManager.this).player.field_70170_p.func_184148_a(null, ((PlayerDataManager)PlayerDataManager.this).player.field_70165_t, ((PlayerDataManager)PlayerDataManager.this).player.field_70163_u, ((PlayerDataManager)PlayerDataManager.this).player.field_70161_v, SoundsRegister.levelUp, SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else if (newLevel == 100 || newLevel == 1000) {
                ((PlayerDataManager)PlayerDataManager.this).player.field_70170_p.func_184148_a(null, ((PlayerDataManager)PlayerDataManager.this).player.field_70165_t, ((PlayerDataManager)PlayerDataManager.this).player.field_70163_u, ((PlayerDataManager)PlayerDataManager.this).player.field_70161_v, SoundsRegister.level100, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            this.levels.put(skill, newLevel);
            this.xp.put(skill, Float.valueOf(0.0f));
            AoAEvents.playerLevelChange(this.playerDataManager, oldLevel, newLevel, skill, isNaturalLevel);
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketSkillData(skill.id, newLevel, this.xp.get((Object)skill).floatValue(), this.optionals.get((Object)skill)), (EntityPlayerMP)PlayerDataManager.this.player);
                AdvancementTriggerRegister.levelUpTrigger.trigger((EntityPlayerMP)PlayerDataManager.this.player, skill, newLevel);
            }
        }

        public void setLevel(Enums.Skills skill, int newLevel) {
            int oldLevel = this.levels.get((Object)skill);
            this.levels.put(skill, MathHelper.func_76125_a((int)newLevel, (int)1, (int)1000));
            this.xp.put(skill, Float.valueOf(0.0f));
            AoAEvents.playerLevelChange(this.playerDataManager, oldLevel, newLevel, skill, false);
            PlayerDataManager.this.applyLegitimacyPenalties();
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketSkillData(skill.id, newLevel, 0.0f, this.optionals.get((Object)skill)), (EntityPlayerMP)PlayerDataManager.this.player);
            }
        }

        public boolean consumeResource(Enums.Resources resource, float value, boolean force) {
            if (resource != Enums.Resources.RAGE && ((PlayerDataManager)PlayerDataManager.this).player.field_71075_bZ.field_75098_d) {
                return true;
            }
            float current = this.resources.get((Object)resource).floatValue();
            if (current < (value = PlayerDataManager.this.buffs.applyResourceFortitudeBuffs(resource, value)) && !force) {
                if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((EntityPlayerMP)PlayerDataManager.this.player, resource, value);
                }
                return false;
            }
            this.resources.put(resource, Float.valueOf(Math.max(current - value, 0.0f)));
            if (resource == Enums.Resources.ENERGY) {
                PlayerDataManager.this.nextEnergyRegenTime = GlobalEvents.tick + 50;
            }
            if (resource == Enums.Resources.RAGE) {
                PlayerDataManager.this.nextRageRegenTime = GlobalEvents.tick + 100;
            }
            PlayerDataManager.this.resourcesUpdated = true;
            return !force || current > value;
        }

        public void regenResource(Enums.Resources resource, float amount) {
            float current = this.resources.get((Object)resource).floatValue();
            float max = 0.0f;
            amount = PlayerDataManager.this.buffs.applyResourceRegenBuffs(resource, amount);
            switch (resource) {
                case CREATION: {
                    max = AuguryUtil.getMaxCreation(this.levels.get((Object)Enums.Skills.AUGURY));
                    break;
                }
                case SOUL: {
                    max = AuguryUtil.getMaxSoul(this.levels.get((Object)Enums.Skills.AUGURY));
                    break;
                }
                case RAGE: 
                case ENERGY: {
                    max = 200.0f;
                    break;
                }
            }
            this.resources.put(resource, Float.valueOf(Math.min(current + amount, max)));
            if (current != max) {
                PlayerDataManager.this.resourcesUpdated = true;
            }
        }

        public void addTribute(Enums.Deities deity, int amount) {
            if (ItemUtil.isHoldingItem((EntityLivingBase)PlayerDataManager.this.player, (Item)WeaponRegister.swordHoly)) {
                amount *= 2;
            }
            this.tribute.put(deity, MathHelper.func_76125_a((int)(this.tribute.get((Object)deity) + amount), (int)0, (int)200));
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketTributeData(this.tribute.get((Object)Enums.Deities.EREBON), this.tribute.get((Object)Enums.Deities.LUXON), this.tribute.get((Object)Enums.Deities.PLUTON), this.tribute.get((Object)Enums.Deities.SELYAN)), (EntityPlayerMP)PlayerDataManager.this.player);
            }
        }

        public void resetAllTribute() {
            for (Enums.Deities deity : Enums.Deities.values()) {
                this.tribute.put(deity, 0);
            }
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketTributeData(this.tribute.get((Object)Enums.Deities.EREBON), this.tribute.get((Object)Enums.Deities.LUXON), this.tribute.get((Object)Enums.Deities.PLUTON), this.tribute.get((Object)Enums.Deities.SELYAN)), (EntityPlayerMP)PlayerDataManager.this.player);
            }
        }

        public void incrementExpeditionBoost() {
            int optExpedition = this.optionals.get((Object)Enums.Skills.EXPEDITION);
            if (optExpedition > 3) {
                if (++optExpedition > 7) {
                    optExpedition = 4;
                }
            } else if (++optExpedition > 3) {
                optExpedition = 0;
            }
            this.optionals.put(Enums.Skills.EXPEDITION, optExpedition);
            if (PlayerDataManager.this.player instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketSkillData(Enums.Skills.EXPEDITION.id, this.levels.get((Object)Enums.Skills.EXPEDITION), this.xp.get((Object)Enums.Skills.EXPEDITION).floatValue(), optExpedition), (EntityPlayerMP)PlayerDataManager.this.player);
            }
        }

        private void saveToNBT(NBTTagCompound baseTag) {
            for (Enums.Skills skills : Enums.Skills.values()) {
                NBTTagCompound skillNBT = new NBTTagCompound();
                skillNBT.func_74768_a("Level", Math.max(1, this.levels.get((Object)skills)));
                skillNBT.func_74776_a("Exp", Math.max(0.0f, this.xp.get((Object)skills).floatValue()));
                if (this.optionals.containsKey((Object)skills)) {
                    skillNBT.func_74768_a("Opt", this.optionals.get((Object)skills).intValue());
                }
                baseTag.func_74782_a(skills.toString(), (NBTBase)skillNBT);
            }
            for (Enum enum_ : Enums.Deities.values()) {
                baseTag.func_74768_a(enum_.toString(), this.tribute.get(enum_).intValue());
            }
            if (PlayerDataManager.this.interventionData != null) {
                NBTTagCompound interventionTag = new NBTTagCompound();
                int i = 0;
                for (ItemStack itemStack : PlayerDataManager.this.interventionData) {
                    interventionTag.func_74782_a(String.valueOf(i), (NBTBase)itemStack.serializeNBT());
                    ++i;
                }
                baseTag.func_74782_a("InterventionData", (NBTBase)interventionTag);
            }
        }

        private void loadFromNBT(NBTTagCompound baseTag) {
            for (Enums.Skills skills : Enums.Skills.values()) {
                NBTTagCompound skillTag = baseTag.func_74775_l(skills.toString());
                this.levels.put(skills, MathHelper.func_76125_a((int)skillTag.func_74762_e("Level"), (int)1, (int)1000));
                this.xp.put(skills, Float.valueOf(Math.max(0.0f, skillTag.func_74760_g("Exp"))));
                if (!skillTag.func_74764_b("Opt")) continue;
                this.optionals.put(skills, skillTag.func_74762_e("Opt"));
            }
            for (Enum enum_ : Enums.Deities.values()) {
                this.tribute.put((Enums.Deities)enum_, MathHelper.func_76125_a((int)baseTag.func_74762_e(enum_.toString()), (int)0, (int)200));
            }
            if (baseTag.func_74764_b("InterventionData")) {
                PlayerDataManager.this.interventionData = new HashSet();
                NBTTagCompound interventionTag = baseTag.func_74775_l("InterventionData");
                int i = 0;
                while (interventionTag.func_74764_b(String.valueOf(i))) {
                    PlayerDataManager.this.interventionData.add(new ItemStack(interventionTag.func_74775_l(String.valueOf(i))));
                    ++i;
                }
            }
        }
    }

    public final class PlayerEquipment {
        private final PlayerDataManager playerDataManager;
        private HashMap<Enums.Counters, Integer> cooldowns = new HashMap(1);
        private HashMap<Enums.ArmourSets, ArmourEffectWrapper> armourMap = new HashMap(4);
        private boolean checkEquipment = true;
        private AdventArmour currentFullSet = null;
        private AdventArmour helmet = null;
        private AdventArmour body = null;
        private AdventArmour legs = null;
        private AdventArmour boots = null;

        private PlayerEquipment(PlayerDataManager playerData) {
            this.playerDataManager = playerData;
        }

        public void markDirty() {
            this.checkEquipment = true;
        }

        public boolean isCooledDown(Enums.Counters counter) {
            return !this.cooldowns.containsKey((Object)counter);
        }

        public int getCooldown(Enums.Counters counter) {
            return this.cooldowns.getOrDefault((Object)counter, 0);
        }

        public void setCooldown(Enums.Counters counter, int cooldownTicks) {
            this.cooldowns.put(counter, cooldownTicks);
        }

        public Enums.ArmourSets getCurrentFullArmourSet() {
            return this.currentFullSet != null ? this.currentFullSet.setType() : Enums.ArmourSets.NONE;
        }

        private void handleIncomingAttack(LivingAttackEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPreAttackReceived(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPreAttackReceived(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        private void handleIncomingDamage(LivingHurtEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onAttackReceived(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onAttackReceived(this.playerDataManager, wrapper.currentSlots, ev);
            }
            PlayerDataManager.this.buffs.applyDefensiveBuffs(ev);
        }

        private void handleOutgoingDamage(LivingHurtEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onDamageDealt(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onDamageDealt(this.playerDataManager, wrapper.currentSlots, ev);
            }
            PlayerDataManager.this.buffs.applyOffensiveBuffs(ev);
        }

        private void handleDamageTriggers(LivingDamageEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPostAttackReceived(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPostAttackReceived(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        private void handlePlayerFalling(LivingFallEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPlayerLandingFall(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPlayerLandingFall(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        private void handlePlayerDeath(LivingDeathEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPlayerDeath(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPlayerDeath(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        void handleEquipmentCheck(PlayerDataManager playerDataManager) {
            if (!this.checkEquipment) {
                return;
            }
            boolean armourChanged = this.checkAndHandleArmourSwap(this.boots, ((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(0)).func_77973_b(), EntityEquipmentSlot.FEET);
            armourChanged |= this.checkAndHandleArmourSwap(this.legs, ((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(1)).func_77973_b(), EntityEquipmentSlot.LEGS);
            armourChanged |= this.checkAndHandleArmourSwap(this.body, ((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(2)).func_77973_b(), EntityEquipmentSlot.CHEST);
            AdventArmour oldSet = this.currentFullSet;
            if (armourChanged |= this.checkAndHandleArmourSwap(this.helmet, ((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(3)).func_77973_b(), EntityEquipmentSlot.HEAD)) {
                if (this.boots != null && this.legs != null && this.body != null && this.helmet != null && this.boots.setType() == this.legs.setType() && this.legs.setType() == this.body.setType() && this.body.isSetHelmet(this.helmet)) {
                    this.currentFullSet = this.boots;
                    if (this.currentFullSet != oldSet) {
                        if (oldSet != null) {
                            this.unequipAdventArmour(playerDataManager, oldSet, null);
                        }
                        this.equipAdventArmour(playerDataManager, this.currentFullSet, null);
                    }
                } else {
                    this.currentFullSet = null;
                    if (oldSet != null) {
                        this.unequipAdventArmour(playerDataManager, oldSet, null);
                    }
                }
            }
            this.checkEquipment = false;
        }

        private boolean checkAndHandleArmourSwap(@Nullable AdventArmour currentPiece, @Nonnull Item newPiece, @Nonnull EntityEquipmentSlot slot) {
            boolean changed = false;
            if (newPiece != currentPiece) {
                changed = true;
                if (currentPiece != null) {
                    this.unequipAdventArmour(this.playerDataManager, currentPiece, slot);
                }
                switch (slot) {
                    case FEET: {
                        AdventArmour adventArmour = this.boots = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (!ItemUtil.hasLevelForItem((Item)this.boots, this.playerDataManager)) break;
                        this.equipAdventArmour(this.playerDataManager, this.boots, slot);
                        break;
                    }
                    case LEGS: {
                        AdventArmour adventArmour = this.legs = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (!ItemUtil.hasLevelForItem((Item)this.legs, this.playerDataManager)) break;
                        this.equipAdventArmour(this.playerDataManager, this.legs, slot);
                        break;
                    }
                    case CHEST: {
                        AdventArmour adventArmour = this.body = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (!ItemUtil.hasLevelForItem((Item)this.body, this.playerDataManager)) break;
                        this.equipAdventArmour(this.playerDataManager, this.body, slot);
                        break;
                    }
                    case HEAD: {
                        AdventArmour adventArmour = this.helmet = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (!ItemUtil.hasLevelForItem((Item)this.helmet, this.playerDataManager)) break;
                        this.equipAdventArmour(this.playerDataManager, this.helmet, slot);
                    }
                }
            }
            return changed;
        }

        private void tickEquipment(PlayerDataManager playerDataManager) {
            if (((PlayerDataManager)PlayerDataManager.this).player.field_70128_L || PlayerDataManager.this.player.func_110143_aJ() <= 0.0f) {
                return;
            }
            boolean doArmourTick = true;
            if (!((PlayerDataManager)PlayerDataManager.this).player.field_71075_bZ.field_75098_d) {
                for (EnumHand hand : EnumHand.values()) {
                    ItemStack heldStack = PlayerDataManager.this.player.func_184586_b(hand);
                    if (!(heldStack.func_77973_b() instanceof SkillItem)) continue;
                    SkillItem item = (SkillItem)heldStack.func_77973_b();
                    if ((Integer)PlayerDataManager.this.stats.levels.get((Object)item.getSkill()) >= item.getLevelReq()) continue;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)PlayerDataManager.this.player, (ItemStack)heldStack);
                    PlayerDataManager.this.player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                if (this.boots != null && !ItemUtil.hasLevelForItem((Item)this.boots, playerDataManager)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)PlayerDataManager.this.player, (ItemStack)((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(0)));
                    ((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.set(0, (Object)ItemStack.field_190927_a);
                    this.unequipAdventArmour(playerDataManager, this.boots, EntityEquipmentSlot.FEET);
                }
                if (this.legs != null && !ItemUtil.hasLevelForItem((Item)this.legs, playerDataManager)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)PlayerDataManager.this.player, (ItemStack)((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(1)));
                    ((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.set(1, (Object)ItemStack.field_190927_a);
                    this.unequipAdventArmour(playerDataManager, this.legs, EntityEquipmentSlot.LEGS);
                }
                if (this.body != null && !ItemUtil.hasLevelForItem((Item)this.body, playerDataManager)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)PlayerDataManager.this.player, (ItemStack)((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(2)));
                    ((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.set(2, (Object)ItemStack.field_190927_a);
                    this.unequipAdventArmour(playerDataManager, this.body, EntityEquipmentSlot.CHEST);
                }
                if (this.helmet != null && !ItemUtil.hasLevelForItem((Item)this.helmet, playerDataManager)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)PlayerDataManager.this.player, (ItemStack)((ItemStack)((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.get(3)));
                    ((PlayerDataManager)PlayerDataManager.this).player.field_71071_by.field_70460_b.set(3, (Object)ItemStack.field_190927_a);
                    this.unequipAdventArmour(playerDataManager, this.helmet, EntityEquipmentSlot.HEAD);
                }
            }
            if (doArmourTick) {
                if (this.currentFullSet != null) {
                    this.currentFullSet.onEffectTick(playerDataManager, null);
                }
                for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                    wrapper.armour.onEffectTick(playerDataManager, wrapper.currentSlots);
                }
            }
            this.handleCooldowns();
            ((PlayerDataManager)PlayerDataManager.this).player.field_71069_bz.func_75142_b();
        }

        private void equipAdventArmour(PlayerDataManager plData, AdventArmour item, @Nullable EntityEquipmentSlot slot) {
            item.onEquip(plData, slot);
            item.addBuffs(PlayerDataManager.this.buffs, slot);
            ArmourEffectWrapper armourEffectWrapper = this.armourMap.get((Object)item.setType());
            if (slot != null) {
                if (armourEffectWrapper == null) {
                    this.armourMap.put(item.setType(), new ArmourEffectWrapper(item, slot));
                } else {
                    armourEffectWrapper.currentSlots.add(slot);
                }
            }
        }

        private void unequipAdventArmour(PlayerDataManager plData, AdventArmour item, @Nullable EntityEquipmentSlot slot) {
            item.onUnequip(plData, slot);
            item.removeBuffs(PlayerDataManager.this.buffs, slot);
            ArmourEffectWrapper armourEffectWrapper = this.armourMap.get((Object)item.setType());
            if (armourEffectWrapper != null && slot != null) {
                if (armourEffectWrapper.currentSlots.size() <= 1) {
                    this.armourMap.remove((Object)item.setType());
                } else {
                    armourEffectWrapper.currentSlots.remove(slot);
                }
            }
        }

        private void handleCooldowns() {
            Iterator<Map.Entry<Enums.Counters, Integer>> cooldownsIterator = this.cooldowns.entrySet().iterator();
            while (cooldownsIterator.hasNext()) {
                Map.Entry<Enums.Counters, Integer> entry = cooldownsIterator.next();
                if (entry.getValue() <= 1) {
                    cooldownsIterator.remove();
                    continue;
                }
                entry.setValue(entry.getValue() - 1);
            }
        }

        private class ArmourEffectWrapper {
            private final AdventArmour armour;
            private final HashSet<EntityEquipmentSlot> currentSlots = new HashSet(4);

            private ArmourEffectWrapper(AdventArmour armour, EntityEquipmentSlot firstSlotEquipped) {
                this.armour = armour;
                this.currentSlots.add(firstSlotEquipped);
            }
        }
    }
}

